/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.renderstate;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.util.PalettedArrayAdapter;
import de.bluecolored.bluemap.core.util.RegistryAdapter;
import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class CellStorage<T extends Cell> {
    private static final BlueNBT BLUE_NBT = new BlueNBT();
    private static final int CACHE_SIZE = 4;
    private final GridStorage storage;
    private final Class<T> type;
    private final LinkedHashMap<Vector2i, T> cells = new LinkedHashMap<Vector2i, T>(8, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Vector2i, T> eldest) {
            if (this.size() <= 4) {
                return false;
            }
            CellStorage.this.saveCell(eldest.getKey(), (Cell)eldest.getValue());
            return true;
        }
    };

    public CellStorage(GridStorage storage, Class<T> type) {
        this.storage = storage;
        this.type = type;
    }

    public synchronized void save() {
        this.cells.forEach(this::saveCell);
    }

    public synchronized void reset() {
        this.cells.clear();
    }

    T cell(int x, int z) {
        return this.cell(new Vector2i(x, z));
    }

    synchronized T cell(Vector2i pos) {
        return (T)this.cells.computeIfAbsent(pos, this::loadCell);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized T loadCell(Vector2i pos) {
        try (CompressedInputStream in = this.storage.read(pos.getX(), pos.getY());){
            if (in == null) return this.createNewCell();
            Cell cell = (Cell)BLUE_NBT.read(in.decompress(), this.type);
            return (T)cell;
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to load render-state cell " + String.valueOf(pos), ex);
            return this.createNewCell();
        }
        catch (RuntimeException ex) {
            Logger.global.logError("Failed to load render-state cell " + String.valueOf(pos), ex);
            try {
                this.storage.delete(pos.getX(), pos.getY());
                return this.createNewCell();
            }
            catch (IOException e) {
                Logger.global.logError("Failed to delete render-state cell " + String.valueOf(pos), e);
            }
        }
        return this.createNewCell();
    }

    protected abstract T createNewCell();

    private synchronized void saveCell(Vector2i pos, T cell) {
        if (!cell.isModified()) {
            return;
        }
        try (OutputStream in = this.storage.write(pos.getX(), pos.getY());){
            BLUE_NBT.write(cell, in, this.type);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save render-state cell " + String.valueOf(pos), ex);
        }
    }

    public GridStorage getStorage() {
        return this.storage;
    }

    static {
        BLUE_NBT.register(TypeToken.of(TileState.class), new RegistryAdapter<TileState>(TileState.REGISTRY, "bluemap", TileState.UNKNOWN));
        BLUE_NBT.register(TypeToken.of(TileState[].class), new PalettedArrayAdapter<TileState>(BLUE_NBT, TileState.class));
    }

    public static interface Cell {
        public boolean isModified();
    }
}

