/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.block;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.block.BlockRenderer;
import de.bluecolored.bluemap.core.resources.BlockColorCalculatorFactory;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.VectorM2f;
import de.bluecolored.bluemap.core.util.math.VectorM3f;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;
import de.bluecolored.bluemap.core.world.block.ExtendedBlock;

public class LiquidModelRenderer
implements BlockRenderer {
    private static final float BLOCK_SCALE = 0.0625f;
    private static final MatrixM3f FLOWING_UV_SCALE = new MatrixM3f().identity().translate(-0.5f, -0.5f).scale(0.5f, 0.5f, 1.0f).translate(0.5f, 0.5f);
    private final ResourcePack resourcePack;
    private final TextureGallery textureGallery;
    private final RenderSettings renderSettings;
    private final BlockColorCalculatorFactory.BlockColorCalculator blockColorCalculator;
    private final VectorM3f[] corners;
    private final VectorM2f[] uvs = new VectorM2f[4];
    private BlockNeighborhood block;
    private BlockState blockState;
    private boolean isWaterlogged;
    private boolean isWaterLike;
    private Model modelResource;
    private TileModelView blockModel;
    private Color blockColor;
    private final Color tintcolor = new Color();
    private final MatrixM3f uvTransform = new MatrixM3f();
    private final VectorM2f flowingVector = new VectorM2f(0.0f, 0.0f);

    public LiquidModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.textureGallery = textureGallery;
        this.renderSettings = renderSettings;
        this.blockColorCalculator = resourcePack.getColorCalculatorFactory().createCalculator();
        this.corners = new VectorM3f[]{new VectorM3f(0.0f, 0.0f, 0.0f), new VectorM3f(0.0f, 0.0f, 16.0f), new VectorM3f(16.0f, 0.0f, 0.0f), new VectorM3f(16.0f, 0.0f, 16.0f), new VectorM3f(0.0f, 16.0f, 0.0f), new VectorM3f(0.0f, 16.0f, 16.0f), new VectorM3f(16.0f, 16.0f, 0.0f), new VectorM3f(16.0f, 16.0f, 16.0f)};
        for (int i = 0; i < this.uvs.length; ++i) {
            this.uvs[i] = new VectorM2f(0.0f, 0.0f);
        }
    }

    @Override
    public void render(BlockNeighborhood block, Variant variant, TileModelView blockModel, Color color) {
        this.block = block;
        this.blockState = block.getBlockState();
        this.isWaterlogged = this.blockState.isWaterlogged() || block.getProperties().isAlwaysWaterlogged();
        this.isWaterLike = this.blockState.isWater() || this.isWaterlogged;
        this.modelResource = variant.getModel().getResource(this.resourcePack::getModel);
        this.blockModel = blockModel;
        this.blockColor = color;
        if (this.modelResource == null) {
            return;
        }
        this.build();
    }

    private void build() {
        int blockLight = this.block.getBlockLightLevel();
        int sunLight = this.block.getSunLightLevel();
        if (this.block.isRemoveIfCave() && (this.renderSettings.isCaveDetectionUsesBlockLight() ? Math.max(blockLight, sunLight) : sunLight) == 0) {
            return;
        }
        int level = this.blockState.getLiquidLevel();
        if (!(level >= 8 || level == 0 && this.isSameLiquid(this.block.getNeighborBlock(0, 1, 0)))) {
            this.corners[4].y = this.getLiquidCornerHeight(-1, -1);
            this.corners[5].y = this.getLiquidCornerHeight(-1, 0);
            this.corners[6].y = this.getLiquidCornerHeight(0, -1);
            this.corners[7].y = this.getLiquidCornerHeight(0, 0);
        } else {
            this.corners[4].y = 16.0f;
            this.corners[5].y = 16.0f;
            this.corners[6].y = 16.0f;
            this.corners[7].y = 16.0f;
        }
        TextureVariable stillVariable = this.modelResource.getTextures().get("still");
        TextureVariable flowVariable = this.modelResource.getTextures().get("flow");
        ResourcePath<Texture> stillTexturePath = stillVariable == null ? null : stillVariable.getTexturePath(this.modelResource.getTextures()::get);
        ResourcePath<Texture> flowTexturePath = flowVariable == null ? null : flowVariable.getTexturePath(this.modelResource.getTextures()::get);
        int stillTextureId = this.textureGallery.get(stillTexturePath);
        int flowTextureId = this.textureGallery.get(flowTexturePath);
        this.tintcolor.set(1.0f, 1.0f, 1.0f, 1.0f, true);
        if (this.isWaterLike) {
            this.blockColorCalculator.getBlendedWaterColor(this.block, this.tintcolor);
        }
        int modelStart = this.blockModel.getStart();
        VectorM3f[] c = this.corners;
        this.createElementFace(Direction.DOWN, c[0], c[2], c[3], c[1], this.tintcolor, stillTextureId, flowTextureId);
        boolean upFaceRendered = this.createElementFace(Direction.UP, c[5], c[7], c[6], c[4], this.tintcolor, stillTextureId, flowTextureId);
        this.createElementFace(Direction.NORTH, c[2], c[0], c[4], c[6], this.tintcolor, stillTextureId, flowTextureId);
        this.createElementFace(Direction.SOUTH, c[1], c[3], c[7], c[5], this.tintcolor, stillTextureId, flowTextureId);
        this.createElementFace(Direction.WEST, c[0], c[1], c[5], c[4], this.tintcolor, stillTextureId, flowTextureId);
        this.createElementFace(Direction.EAST, c[3], c[2], c[6], c[7], this.tintcolor, stillTextureId, flowTextureId);
        this.blockModel.initialize(modelStart);
        this.blockModel.scale(0.0625f, 0.0625f, 0.0625f);
        if (upFaceRendered) {
            Texture stillTexture;
            Texture texture = stillTexture = stillTexturePath == null ? null : stillTexturePath.getResource(this.resourcePack::getTexture);
            if (stillTexture != null) {
                this.blockColor.set(stillTexture.getColorPremultiplied());
                this.blockColor.multiply(this.tintcolor);
                float combinedLight = (float)Math.max(sunLight, blockLight) / 15.0f;
                combinedLight = (this.renderSettings.getAmbientLight() + combinedLight) / (this.renderSettings.getAmbientLight() + 1.0f);
                this.blockColor.r *= combinedLight;
                this.blockColor.g *= combinedLight;
                this.blockColor.b *= combinedLight;
            }
        } else {
            this.blockColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
        }
    }

    private float getLiquidCornerHeight(int x, int z) {
        int iz;
        int ix;
        for (ix = x; ix <= x + 1; ++ix) {
            for (iz = z; iz <= z + 1; ++iz) {
                if (!this.isSameLiquid(this.block.getNeighborBlock(ix, 1, iz))) continue;
                return 16.0f;
            }
        }
        float sumHeight = 0.0f;
        int count = 0;
        for (ix = x; ix <= x + 1; ++ix) {
            for (iz = z; iz <= z + 1; ++iz) {
                ExtendedBlock neighbor = this.block.getNeighborBlock(ix, 0, iz);
                BlockState neighborBlockState = neighbor.getBlockState();
                if (this.isSameLiquid(neighbor)) {
                    if (neighborBlockState.getLiquidLevel() == 0) {
                        return 14.0f;
                    }
                    sumHeight += this.getLiquidBaseHeight(neighborBlockState);
                    ++count;
                    continue;
                }
                if (this.isLiquidBlockingBlock(neighborBlockState)) continue;
                ++count;
            }
        }
        if (sumHeight == 0.0f) {
            return 3.0f;
        }
        if (count == 0) {
            return 3.0f;
        }
        return sumHeight / (float)count;
    }

    private boolean isLiquidBlockingBlock(BlockState blockState) {
        return !blockState.isAir();
    }

    private boolean isSameLiquid(ExtendedBlock block) {
        BlockState blockState = block.getBlockState();
        if (this.isWaterlogged) {
            return blockState.isWater() || blockState.isWaterlogged() || block.getProperties().isAlwaysWaterlogged();
        }
        if (blockState.getFormatted() == this.blockState.getFormatted()) {
            return true;
        }
        return this.isWaterLike && (blockState.isWaterlogged() || block.getProperties().isAlwaysWaterlogged());
    }

    private float getLiquidBaseHeight(BlockState block) {
        int level = block.getLiquidLevel();
        return level >= 8 ? 16.0f : 14.0f - (float)level * 1.9f;
    }

    private boolean createElementFace(Direction faceDir, VectorM3f c0, VectorM3f c1, VectorM3f c2, VectorM3f c3, Color color, int stillTextureId, int flowTextureId) {
        int sunLight;
        int blockLight;
        Vector3i faceDirVector = faceDir.toVector();
        ExtendedBlock bl = this.block.getNeighborBlock(faceDirVector.getX(), faceDirVector.getY(), faceDirVector.getZ());
        if (this.isSameLiquid(bl) || faceDir != Direction.UP && bl.getProperties().isCulling()) {
            return false;
        }
        this.blockModel.initialize();
        this.blockModel.add(2);
        TileModel tileModel = this.blockModel.getTileModel();
        int face1 = this.blockModel.getStart();
        int face2 = face1 + 1;
        tileModel.setPositions(face1, c0.x, c0.y, c0.z, c1.x, c1.y, c1.z, c2.x, c2.y, c2.z);
        tileModel.setPositions(face2, c0.x, c0.y, c0.z, c2.x, c2.y, c2.z, c3.x, c3.y, c3.z);
        this.uvs[0].set(0.0f, 1.0f);
        this.uvs[1].set(1.0f, 1.0f);
        this.uvs[2].set(1.0f, 0.0f);
        this.uvs[3].set(0.0f, 0.0f);
        boolean flow = false;
        if (faceDir == Direction.UP) {
            int flowAngle = this.getFlowingAngle();
            if (flowAngle != -1) {
                flow = true;
                this.uvTransform.identity().translate(-0.5f, -0.5f).scale(0.5f, 0.5f, 1.0f).rotate(-flowAngle, 0.0f, 0.0f, 1.0f).translate(0.5f, 0.5f);
                this.uvs[0].transform(this.uvTransform);
                this.uvs[1].transform(this.uvTransform);
                this.uvs[2].transform(this.uvTransform);
                this.uvs[3].transform(this.uvTransform);
            }
        } else if (faceDir != Direction.DOWN) {
            flow = true;
            this.uvs[0].transform(FLOWING_UV_SCALE);
            this.uvs[1].transform(FLOWING_UV_SCALE);
            this.uvs[2].transform(FLOWING_UV_SCALE);
            this.uvs[3].transform(FLOWING_UV_SCALE);
        }
        tileModel.setUvs(face1, this.uvs[0].x, this.uvs[0].y, this.uvs[1].x, this.uvs[1].y, this.uvs[2].x, this.uvs[2].y);
        tileModel.setUvs(face2, this.uvs[0].x, this.uvs[0].y, this.uvs[2].x, this.uvs[2].y, this.uvs[3].x, this.uvs[3].y);
        tileModel.setMaterialIndex(face1, flow ? flowTextureId : stillTextureId);
        tileModel.setMaterialIndex(face2, flow ? flowTextureId : stillTextureId);
        tileModel.setColor(face1, color.r, color.g, color.b);
        tileModel.setColor(face2, color.r, color.g, color.b);
        tileModel.setAOs(face1, 1.0f, 1.0f, 1.0f);
        tileModel.setAOs(face2, 1.0f, 1.0f, 1.0f);
        if (faceDir == Direction.UP) {
            blockLight = this.block.getBlockLightLevel();
            sunLight = this.block.getSunLightLevel();
        } else {
            blockLight = bl.getBlockLightLevel();
            sunLight = bl.getSunLightLevel();
        }
        tileModel.setBlocklight(face1, blockLight);
        tileModel.setBlocklight(face2, blockLight);
        tileModel.setSunlight(face1, sunLight);
        tileModel.setSunlight(face2, sunLight);
        return true;
    }

    private int getFlowingAngle() {
        float own = this.getLiquidBaseHeight(this.blockState) * 0.0625f;
        if ((double)own > 0.8) {
            return -1;
        }
        this.flowingVector.set(0.0f, 0.0f);
        this.flowingVector.x += this.compareLiquidHeights(own, -1, 0);
        this.flowingVector.x -= this.compareLiquidHeights(own, 1, 0);
        this.flowingVector.y -= this.compareLiquidHeights(own, 0, -1);
        this.flowingVector.y += this.compareLiquidHeights(own, 0, 1);
        if (this.flowingVector.x == 0.0f && this.flowingVector.y == 0.0f) {
            return -1;
        }
        int angle = (int)((double)this.flowingVector.angleTo(0.0f, -1.0f) * 57.29577951308232);
        return this.flowingVector.x < 0.0f ? angle : -angle;
    }

    private float compareLiquidHeights(float ownHeight, int dx, int dz) {
        ExtendedBlock neighbor = this.block.getNeighborBlock(dx, 0, dz);
        if (neighbor.getBlockState().isAir()) {
            return 0.0f;
        }
        if (!this.isSameLiquid(neighbor)) {
            return 0.0f;
        }
        float otherHeight = this.getLiquidBaseHeight(neighbor.getBlockState()) * 0.0625f;
        return otherHeight - ownHeight;
    }
}

