/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.debug;

import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.common.debug.DebugDump;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;

public class StateDumper {
    private static final StateDumper GLOBAL = new StateDumper();
    private final Set<Object> instances = Collections.newSetFromMap(new WeakHashMap());

    public void dump(Path file) throws IOException {
        JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
        writer.setIndent(" ");
        writer.beginObject();
        writer.name("system-info");
        this.collectSystemInfo(writer);
        Set<Object> alreadyDumped = Collections.newSetFromMap(new IdentityHashMap());
        writer.name("threads").beginArray();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            this.dumpInstance(thread, writer, alreadyDumped);
        }
        writer.endArray();
        writer.name("dump").beginObject();
        for (Object instance : this.instances) {
            Class<?> type = instance.getClass();
            writer.name(type.getName());
            this.dumpInstance(instance, writer, alreadyDumped);
        }
        writer.endObject();
        writer.endObject();
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInstance(Object instance, JsonWriter writer, Set<Object> alreadyDumped) throws IOException {
        if (instance == null) {
            writer.nullValue();
            return;
        }
        if (instance instanceof String || instance instanceof Path || instance instanceof UUID || instance instanceof Key) {
            writer.value(instance.toString());
            return;
        }
        if (instance instanceof Number) {
            Number val = (Number)instance;
            writer.value(val);
            return;
        }
        if (instance instanceof Boolean) {
            Boolean val = (Boolean)instance;
            writer.value(val);
            return;
        }
        if (!alreadyDumped.add(instance)) {
            writer.value("<<" + StateDumper.toIdentityString(instance) + ">>");
            return;
        }
        writer.beginObject();
        try {
            String identityString = StateDumper.toIdentityString(instance);
            writer.name("#identity").value(identityString);
            if (instance instanceof Map) {
                Map map = (Map)instance;
                writer.name("entries").beginArray();
                int count = 0;
                for (Map.Entry entry : map.entrySet()) {
                    if (++count > 30) {
                        writer.value("<<" + (map.size() - 30) + " more elements>>");
                        break;
                    }
                    writer.beginObject();
                    writer.name("key");
                    this.dumpInstance(entry.getKey(), writer, alreadyDumped);
                    writer.name("value");
                    this.dumpInstance(entry.getValue(), writer, alreadyDumped);
                    writer.endObject();
                }
                writer.endArray();
                return;
            }
            if (instance instanceof Collection) {
                Collection collection = (Collection)instance;
                writer.name("entries").beginArray();
                int count = 0;
                for (Object entry : collection) {
                    if (++count > 30) {
                        writer.value("<<" + (collection.size() - 30) + " more elements>>");
                        break;
                    }
                    this.dumpInstance(entry, writer, alreadyDumped);
                }
                writer.endArray();
                return;
            }
            if (instance instanceof Object[]) {
                Object[] array = (Object[])instance;
                writer.name("entries").beginArray();
                int count = 0;
                for (Object entry : array) {
                    if (++count > 30) {
                        writer.value("<<" + (array.length - 30) + " more elements>>");
                        break;
                    }
                    this.dumpInstance(entry, writer, alreadyDumped);
                }
                writer.endArray();
                return;
            }
            String toString = instance.toString();
            if (!toString.equals(identityString)) {
                writer.name("#toString").value(instance.toString());
            }
            if (instance instanceof Thread) {
                Thread thread = (Thread)instance;
                writer.name("name").value(thread.getName());
                writer.name("state").value(thread.getState().toString());
                writer.name("priority").value((long)thread.getPriority());
                writer.name("alive").value(thread.isAlive());
                writer.name("id").value(thread.getId());
                writer.name("deamon").value(thread.isDaemon());
                writer.name("interrupted").value(thread.isInterrupted());
                try {
                    StackTraceElement[] trace = thread.getStackTrace();
                    writer.name("stacktrace").beginArray();
                    for (StackTraceElement element : trace) {
                        writer.value(element.toString());
                    }
                    writer.endArray();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return;
            }
            this.dumpAnnotatedInstance(instance.getClass(), instance, writer, alreadyDumped);
        }
        finally {
            writer.endObject();
        }
    }

    private static String toIdentityString(Object instance) {
        return instance.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(instance));
    }

    private void dumpAnnotatedInstance(Class<?> type, Object instance, JsonWriter writer, Set<Object> alreadyDumped) throws IOException {
        Object value;
        DebugDump dd;
        String key;
        DebugDump typedd = type.getAnnotation(DebugDump.class);
        boolean exclude = typedd != null && typedd.exclude();
        boolean allFields = !exclude && (typedd != null || type.getPackageName().startsWith("de.bluecolored.bluemap"));
        for (Field field : type.getDeclaredFields()) {
            key = field.getName();
            try {
                dd = field.getAnnotation(DebugDump.class);
                if (dd != null ? dd.exclude() : !allFields || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                if (dd != null && (key = dd.value()).isEmpty()) {
                    key = field.getName();
                }
                field.setAccessible(true);
                value = field.get(instance);
            }
            catch (Exception ex) {
                writer.name("!!" + key).value(ex.toString());
                continue;
            }
            writer.name(key);
            this.dumpInstance(value, writer, alreadyDumped);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            key = ((Method)accessibleObject).toGenericString();
            try {
                dd = ((Method)accessibleObject).getAnnotation(DebugDump.class);
                if (dd == null || dd.exclude()) continue;
                key = dd.value();
                if (key.isEmpty()) {
                    key = ((Method)accessibleObject).toGenericString();
                }
                ((Method)accessibleObject).setAccessible(true);
                value = ((Method)accessibleObject).invoke(instance, new Object[0]);
            }
            catch (Exception ex) {
                writer.name("!!" + key).value(ex.toString());
                continue;
            }
            writer.name(key);
            this.dumpInstance(value, writer, alreadyDumped);
        }
        for (AnnotatedElement annotatedElement : type.getInterfaces()) {
            this.dumpAnnotatedInstance((Class<?>)annotatedElement, instance, writer, alreadyDumped);
        }
        Class<?> typeSuperclass = type.getSuperclass();
        if (typeSuperclass != null) {
            this.dumpAnnotatedInstance(typeSuperclass, instance, writer, alreadyDumped);
        }
    }

    private void collectSystemInfo(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("bluemap-version").value(BlueMap.VERSION);
        writer.name("git-hash").value(BlueMap.GIT_HASH);
        String[] properties = new String[]{"java.runtime.name", "java.runtime.version", "java.vm.vendor", "java.vm.name", "os.name", "os.version", "user.dir", "java.home", "file.separator", "sun.io.unicode.encoding", "java.class.version"};
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (String key : properties) {
            propMap.put(key, System.getProperty(key));
        }
        writer.name("properties");
        this.dumpInstance(propMap, writer, new HashSet<Object>());
        writer.name("cores").value((long)Runtime.getRuntime().availableProcessors());
        writer.name("max-memory").value(Runtime.getRuntime().maxMemory());
        writer.name("total-memory").value(Runtime.getRuntime().totalMemory());
        writer.name("free-memory").value(Runtime.getRuntime().freeMemory());
        writer.name("timestamp").value(System.currentTimeMillis());
        writer.name("time").value(LocalDateTime.now().toString());
        writer.endObject();
    }

    public static StateDumper global() {
        return GLOBAL;
    }

    public synchronized void register(Object instance) {
        StateDumper.GLOBAL.instances.add(instance);
    }
}

