/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluecommands.annotations.Parser;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.storage.FileConfig;
import de.bluecolored.bluemap.common.config.storage.SQLConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.StorageDeleteTask;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.file.FileStorage;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import de.bluecolored.shadow.adventure.adventure.text.TextComponent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;

public class StoragesCommand {
    private final Plugin plugin;

    @Command(value={"storages"})
    @Permission(value="bluemap.storages")
    public Component storageList() {
        Map<String, Storage> loadedStorages = this.plugin.getBlueMap().getLoadedStorages();
        Component[] lines = (Component[])this.plugin.getBlueMap().getConfig().getStorageConfigs().entrySet().stream().map(storage -> this.formatStorageEntry((String)storage.getKey(), (StorageConfig)storage.getValue(), loadedStorages.containsKey(storage.getKey()))).toArray(Component[]::new);
        return TextFormat.paragraph("Storages", TextFormat.lines(lines));
    }

    private Component formatStorageEntry(String id, StorageConfig storage, boolean loaded) {
        Component loadedIcon = loaded ? Component.text("\u2714").color(TextFormat.POSITIVE_COLOR) : Component.text("\u274c").color(TextFormat.BASE_COLOR);
        return TextFormat.format("% %", loadedIcon, Component.text(id).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR);
    }

    @Command(value={"storages <storage>"})
    @Permission(value="bluemap.storages")
    public Component storage(CommandSource source, @Argument(value="storage") @Parser(value="storage-id") String storageId) throws ConfigurationException, InterruptedException, IOException {
        Map<String, Storage> loadedStorages = this.plugin.getBlueMap().getLoadedStorages();
        Storage storage = loadedStorages.get(storageId);
        StorageConfig storageConfig = this.plugin.getBlueMap().getConfig().getStorageConfigs().get(storageId);
        if (storage == null) {
            source.sendMessage(TextFormat.format("Initializing storage '%'...", storageId).color(TextFormat.BASE_COLOR));
            storage = this.plugin.getBlueMap().getOrLoadStorage(storageId);
        }
        LinkedList<Component> lines = new LinkedList<Component>();
        lines.add(TextFormat.format("Type: %", Component.text(storageConfig.getStorageType().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        if (storage instanceof FileStorage) {
            FileStorage fileStorage = (FileStorage)storage;
            lines.add(TextFormat.format("Path: %", Component.text(BlueMapConfigManager.formatPath(fileStorage.getRoot())).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        if (storageConfig instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)storageConfig;
            lines.add(TextFormat.format("Compression: %", Component.text(fileConfig.getCompression().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        if (storageConfig instanceof SQLConfig) {
            SQLConfig sqlConfig = (SQLConfig)storageConfig;
            lines.add(TextFormat.format("Dialect: %", Component.text(sqlConfig.getDialect().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
            lines.add(TextFormat.format("Compression: %", Component.text(sqlConfig.getCompression().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        lines.add(Component.empty());
        lines.add(Component.text("Maps:").color(TextFormat.BASE_COLOR));
        storage.mapIds().limit(20L).map(this::formatMapEntry).forEach(lines::add);
        return TextFormat.paragraph("Storage '%s'".formatted(storageId), TextFormat.lines(lines));
    }

    private Component formatMapEntry(String id) {
        BmMap map = this.plugin.getBlueMap().getMaps().get(id);
        Component loadedIcon = map != null ? Component.text("\u2714").color(TextFormat.POSITIVE_COLOR) : Component.text("\u274c").color(TextFormat.BASE_COLOR);
        return TextFormat.format("% %", loadedIcon, Component.text(id).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR);
    }

    @Command(value={"storages <storage> delete <map>"})
    @Permission(value="bluemap.storages.delete")
    public void deleteMap(CommandSource source, @Argument(value="storage") @Parser(value="storage-id") String storageId, @Argument(value="map") String mapId) throws ConfigurationException, InterruptedException {
        Map<String, Storage> loadedStorages = this.plugin.getBlueMap().getLoadedStorages();
        Storage storage = loadedStorages.get(storageId);
        if (storage == null) {
            source.sendMessage(TextFormat.format("Initializing storage %...", storageId).color(TextFormat.BASE_COLOR));
            storage = this.plugin.getBlueMap().getOrLoadStorage(storageId);
        }
        if (this.plugin.getBlueMap().getMaps().containsKey(mapId)) {
            source.sendMessage(((TextComponent)Component.text("Can't delete a loaded map!").color(TextFormat.NEGATIVE_COLOR)).append(TextFormat.format("Unload the map by removing it's config-file first,\nor use % if you want to purge it.\n".strip(), TextFormat.command("/bluemap purge " + mapId).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)));
            return;
        }
        StorageDeleteTask task = new StorageDeleteTask(storage.map(mapId), mapId);
        this.plugin.getRenderManager().scheduleRenderTaskNext(task);
        source.sendMessage(TextFormat.lines(TextFormat.format("Scheduled a new task to delete map % from storage %", Component.text(mapId).color(TextFormat.HIGHLIGHT_COLOR), Component.text(storageId).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR), TextFormat.format("Use % to see the progress", TextFormat.command("/bluemap").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)));
    }

    public StoragesCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

