/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluecommands.BlueCommands;
import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.CommandExecutable;
import de.bluecolored.bluecommands.LiteralCommand;
import de.bluecolored.bluecommands.MethodCommandExecutable;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.Unloaded;
import de.bluecolored.bluemap.common.commands.WithPosition;
import de.bluecolored.bluemap.common.commands.WithWorld;
import de.bluecolored.bluemap.common.commands.arguments.MapBackedArgumentParser;
import de.bluecolored.bluemap.common.commands.arguments.StringSetArgumentParser;
import de.bluecolored.bluemap.common.commands.commands.DebugCommand;
import de.bluecolored.bluemap.common.commands.commands.FreezeCommand;
import de.bluecolored.bluemap.common.commands.commands.HelpCommand;
import de.bluecolored.bluemap.common.commands.commands.MapListCommand;
import de.bluecolored.bluemap.common.commands.commands.PurgeCommand;
import de.bluecolored.bluemap.common.commands.commands.ReloadCommand;
import de.bluecolored.bluemap.common.commands.commands.StartCommand;
import de.bluecolored.bluemap.common.commands.commands.StatusCommand;
import de.bluecolored.bluemap.common.commands.commands.StopCommand;
import de.bluecolored.bluemap.common.commands.commands.StoragesCommand;
import de.bluecolored.bluemap.common.commands.commands.TasksCommand;
import de.bluecolored.bluemap.common.commands.commands.TroubleshootCommand;
import de.bluecolored.bluemap.common.commands.commands.UnfreezeCommand;
import de.bluecolored.bluemap.common.commands.commands.UpdateCommand;
import de.bluecolored.bluemap.common.commands.commands.VersionCommand;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.TileUpdateStrategy;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import de.bluecolored.shadow.caffeine.cache.Cache;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Commands {
    private static final Cache<String, RenderTask> REF_TO_RENDERTASK = Caffeine.newBuilder().weakValues().build();
    private static final LoadingCache<RenderTask, String> RENDERTASK_TO_REF = Caffeine.newBuilder().weakKeys().build(Commands::safeRandomRef);

    public static Command<CommandSource, Object> create(Plugin plugin) {
        BlueCommands<CommandSource> builder = new BlueCommands<CommandSource>();
        builder.setArgumentParserForArgumentType(BmMap.class, new MapBackedArgumentParser("map", () -> plugin.isLoaded() ? plugin.getBlueMap().getMaps() : Map.of()));
        builder.setArgumentParserForArgumentType(StorageConfig.class, new MapBackedArgumentParser("storage", () -> plugin.isLoaded() ? plugin.getBlueMap().getConfig().getStorageConfigs() : Map.of()));
        builder.setArgumentParserForArgumentType(RenderTask.class, new MapBackedArgumentParser<RenderTask>("render-task", REF_TO_RENDERTASK.asMap()));
        builder.setArgumentParserForId("storage-id", new StringSetArgumentParser("storage", () -> plugin.isLoaded() ? plugin.getBlueMap().getConfig().getStorageConfigs().keySet() : Set.of()));
        builder.setContextResolverForType(ServerWorld.class, c -> c.getWorld().orElse(null));
        builder.setContextResolverForType(World.class, c -> plugin.isLoaded() ? (World)c.getWorld().map(plugin::getWorld).orElse(null) : null);
        builder.setContextResolverForType(Vector3d.class, c -> c.getPosition().orElse(null));
        builder.setAnnotationContextPredicate(Permission.class, (permission, commandSource) -> permission == null || commandSource.hasPermission(permission.value()));
        builder.setAnnotationContextPredicate(WithWorld.class, (withWorld, commandSource) -> {
            if (withWorld == null) return true;
            if (!plugin.isLoaded()) return false;
            if (!commandSource.getWorld().map(plugin::getWorld).isPresent()) return false;
            return true;
        });
        builder.setAnnotationContextPredicate(WithPosition.class, (withPosition, commandSource) -> withPosition == null || commandSource.getPosition().isPresent());
        LiteralCommand<CommandSource, Object> commands = new LiteralCommand<CommandSource, Object>("bluemap");
        Stream.of(new DebugCommand(plugin), new FreezeCommand(plugin), new HelpCommand(plugin), new MapListCommand(plugin), new PurgeCommand(plugin), new ReloadCommand(plugin), new StartCommand(plugin), new StatusCommand(plugin), new StopCommand(plugin), new StoragesCommand(plugin), new TasksCommand(plugin), new TroubleshootCommand(plugin), new UnfreezeCommand(plugin), new VersionCommand(plugin)).map(builder::createCommand).forEach(commands::addSubCommand);
        Map.of("update", TileUpdateStrategy.FORCE_NONE, "fix-edges", TileUpdateStrategy.FORCE_EDGE, "force-update", TileUpdateStrategy.FORCE_ALL).forEach((updateLiteral, strategy) -> {
            LiteralCommand updateCommand = new LiteralCommand((String)updateLiteral);
            updateCommand.addSubCommand(builder.createCommand(new UpdateCommand(plugin, (TileUpdateStrategy)strategy)));
            commands.addSubCommand(updateCommand);
        });
        return commands;
    }

    public static String getRefForTask(RenderTask task) {
        return RENDERTASK_TO_REF.get(task);
    }

    @Nullable
    public static RenderTask getTaskForRef(String ref) {
        return REF_TO_RENDERTASK.getIfPresent(ref);
    }

    public static boolean checkExecutablePreconditions(Plugin plugin, CommandSource context, CommandExecutable<CommandSource, Object> executable) {
        MethodCommandExecutable methodExecutable;
        if (executable instanceof MethodCommandExecutable && (methodExecutable = (MethodCommandExecutable)executable).getMethod().getAnnotation(Unloaded.class) == null) {
            return Commands.checkPluginLoaded(plugin, context);
        }
        return true;
    }

    public static boolean checkPluginLoaded(Plugin plugin, CommandSource context) {
        if (!plugin.isLoaded()) {
            if (plugin.isLoading()) {
                context.sendMessage(TextFormat.lines(Component.text("\u231b BlueMap is still loading!").color(TextFormat.INFO_COLOR), Component.text("Please try again in a few seconds.").color(TextFormat.BASE_COLOR)));
            } else {
                context.sendMessage(TextFormat.lines(Component.text("\u274c BlueMap is not loaded!").color(TextFormat.NEGATIVE_COLOR), TextFormat.format("Check your server-console for errors or warnings and try using %.", TextFormat.command("/bluemap reload").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)));
            }
            return false;
        }
        return true;
    }

    private static synchronized String safeRandomRef(RenderTask task) {
        String ref = Commands.randomRef();
        while (REF_TO_RENDERTASK.asMap().putIfAbsent(ref, task) != null) {
            ref = Commands.randomRef();
        }
        return ref;
    }

    private static String randomRef() {
        StringBuilder ref = new StringBuilder(Integer.toString(Math.abs(new Random().nextInt()), 16));
        while (ref.length() < 4) {
            ref.insert(0, "0");
        }
        return ref.subSequence(0, 4).toString();
    }
}

