/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.api.gson.MarkerGson;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.common.BlueMapConfiguration;
import de.bluecolored.bluemap.common.MissingResourcesException;
import de.bluecolored.bluemap.common.WebFilesManager;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.MapConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.debug.StateDumper;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.resources.MinecraftVersion;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.util.FileHelper;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import de.bluecolored.shadow.configurate.ConfigurateException;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.HeaderMode;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class BlueMapService
implements Closeable {
    private final BlueMapConfiguration config;
    private final WebFilesManager webFilesManager;
    private MinecraftVersion minecraftVersion;
    private ResourcePack resourcePack;
    private final Map<String, World> worlds;
    private final Map<String, BmMap> maps;
    private final Map<String, Storage> storages;

    public BlueMapService(BlueMapConfiguration configuration, @Nullable ResourcePack preloadedResourcePack) {
        this(configuration);
        this.resourcePack = preloadedResourcePack;
    }

    public BlueMapService(BlueMapConfiguration configuration) {
        this.config = configuration;
        this.webFilesManager = new WebFilesManager(this.config.getWebappConfig().getWebroot());
        this.worlds = new ConcurrentHashMap<String, World>();
        this.maps = new ConcurrentHashMap<String, BmMap>();
        this.storages = new ConcurrentHashMap<String, Storage>();
        StateDumper.global().register(this);
    }

    public WebFilesManager getWebFilesManager() {
        return this.webFilesManager;
    }

    public synchronized void createOrUpdateWebApp(boolean force) throws ConfigurationException {
        try {
            WebFilesManager webFilesManager = this.getWebFilesManager();
            if (force || webFilesManager.filesNeedUpdate()) {
                webFilesManager.updateFiles();
            }
            if (!this.config.getWebappConfig().isUpdateSettingsFile()) {
                webFilesManager.loadSettings();
                webFilesManager.addFrom(this.config.getWebappConfig());
            } else {
                webFilesManager.setFrom(this.config.getWebappConfig());
            }
            for (String mapId : this.config.getMapConfigs().keySet()) {
                webFilesManager.addMap(mapId);
            }
            webFilesManager.saveSettings();
        }
        catch (IOException ex) {
            throw new ConfigurationException("Failed to update web-app files!", ex);
        }
    }

    public Map<String, BmMap> getMaps() {
        return Collections.unmodifiableMap(this.maps);
    }

    public Map<String, World> getWorlds() {
        return Collections.unmodifiableMap(this.worlds);
    }

    public Map<String, BmMap> getOrLoadMaps() throws InterruptedException {
        return this.getOrLoadMaps(mapId -> true);
    }

    public synchronized Map<String, BmMap> getOrLoadMaps(Predicate<String> filter) throws InterruptedException {
        for (Map.Entry<String, MapConfig> entry : this.config.getMapConfigs().entrySet()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!filter.test(entry.getKey()) || this.maps.containsKey(entry.getKey())) continue;
            try {
                this.loadMap(entry.getKey(), entry.getValue());
            }
            catch (ConfigurationException ex) {
                Logger.global.logWarning(ex.getFormattedExplanation());
                Throwable cause = ex.getRootCause();
                if (cause == null) continue;
                Logger.global.logError("Detailed error:", ex);
            }
        }
        return Collections.unmodifiableMap(this.maps);
    }

    private synchronized void loadMap(String id, MapConfig mapConfig) throws ConfigurationException, InterruptedException {
        String name = mapConfig.getName();
        if (name == null) {
            name = id;
        }
        Path worldFolder = mapConfig.getWorld();
        Key dimension = mapConfig.getDimension();
        if (worldFolder == null) {
            Logger.global.logInfo("The map '" + name + "' has no world configured. The map will be displayed, but it will not be updated by this bluemap instance!");
            return;
        }
        if (dimension == null) {
            if ((worldFolder = worldFolder.normalize()).endsWith("DIM-1")) {
                worldFolder = worldFolder.getParent();
                dimension = DataPack.DIMENSION_THE_NETHER;
            } else if (worldFolder.endsWith("DIM1")) {
                worldFolder = worldFolder.getParent();
                dimension = DataPack.DIMENSION_THE_END;
            } else if (worldFolder.getNameCount() > 3 && worldFolder.getName(worldFolder.getNameCount() - 3).toString().equals("dimensions")) {
                String namespace = worldFolder.getName(worldFolder.getNameCount() - 2).toString();
                String value = worldFolder.getName(worldFolder.getNameCount() - 1).toString();
                worldFolder = worldFolder.subpath(0, worldFolder.getNameCount() - 3);
                dimension = new Key(namespace, value);
            } else {
                dimension = DataPack.DIMENSION_OVERWORLD;
            }
            Logger.global.logInfo("The map '" + name + "' has no dimension configured.\nAssuming world: '" + String.valueOf(worldFolder) + "' and dimension: '" + String.valueOf(dimension) + "'.");
        }
        if (!Files.isDirectory(worldFolder, new LinkOption[0])) {
            throw new ConfigurationException("'" + String.valueOf(worldFolder.toAbsolutePath().normalize()) + "' does not exist or is no directory!\nCheck if the 'world' setting in the config-file for that map is correct, or remove the entire config-file if you don't want that map.");
        }
        String worldId = World.id(worldFolder, dimension);
        World world = this.worlds.get(worldId);
        if (world == null) {
            try {
                Logger.global.logDebug("Loading world " + worldId + " ...");
                world = MCAWorld.load(worldFolder, dimension, this.loadDataPack(worldFolder));
                this.worlds.put(worldId, world);
            }
            catch (IOException ex) {
                throw new ConfigurationException("Failed to load world " + worldId + "!\nIs the level.dat of that world present and not corrupted?", ex);
            }
        }
        Storage storage = this.getOrLoadStorage(mapConfig.getStorage());
        try {
            Logger.global.logInfo("Loading map '" + id + "'...");
            BmMap map = new BmMap(id, name, world, storage.map(id), this.getOrLoadResourcePack(), mapConfig);
            this.maps.put(id, map);
            ConfigurationNode markerSetNode = mapConfig.getMarkerSets();
            if (markerSetNode != null && !markerSetNode.empty()) {
                String markerJson = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().headerMode(HeaderMode.NONE)).lenient(false).indent(0).buildAndSaveString(markerSetNode);
                Gson gson = MarkerGson.addAdapters(new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).create();
                Type markerSetType = new TypeToken<Map<String, MarkerSet>>(this){}.getType();
                Map markerSets = (Map)gson.fromJson(markerJson, markerSetType);
                map.getMarkerSets().putAll(markerSets);
            }
        }
        catch (JsonParseException | ConfigurateException ex) {
            throw new ConfigurationException("Failed to create the markers for map '" + id + "'!\nMake sure your marker-configuration for this map is valid.", ex);
        }
        catch (ConfigurationException | IOException ex) {
            throw new ConfigurationException("Failed to load map '" + id + "'!", ex);
        }
    }

    public synchronized Storage getOrLoadStorage(String storageId) throws ConfigurationException, InterruptedException {
        Storage storage = this.storages.get(storageId);
        if (storage == null) {
            try {
                StorageConfig storageConfig = this.getConfig().getStorageConfigs().get(storageId);
                if (storageConfig == null) {
                    throw new ConfigurationException("There is no storage-configuration for '" + storageId + "'!\nYou will either need to define that storage, or change the map-config to use a storage-config that exists.");
                }
                Logger.global.logInfo("Initializing Storage: '" + storageId + "' (Type: '" + String.valueOf(storageConfig.getStorageType().getKey()) + "')");
                storage = storageConfig.createStorage();
                storage.initialize();
            }
            catch (Exception ex) {
                ConfigurationException confEx = new ConfigurationException("Failed to load and initialize the storage '" + storageId + "'!", ex);
                if (storage != null) {
                    try {
                        storage.close();
                    }
                    catch (Exception closeEx) {
                        confEx.addSuppressed(closeEx);
                    }
                }
                throw confEx;
            }
            this.storages.put(storageId, storage);
        }
        return storage;
    }

    public Map<String, Storage> getLoadedStorages() {
        return Collections.unmodifiableMap(this.storages);
    }

    @Nullable
    public ResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public synchronized ResourcePack getOrLoadResourcePack() throws ConfigurationException, InterruptedException {
        if (this.resourcePack == null) {
            MinecraftVersion minecraftVersion = this.getOrLoadMinecraftVersion();
            Path vanillaResourcePack = minecraftVersion.getResourcePack();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Deque<Path> packRoots = this.getPackRoots(new Path[0]);
            packRoots.addLast(vanillaResourcePack);
            try {
                ResourcePack resourcePack = new ResourcePack(minecraftVersion.getResourcePackVersion());
                resourcePack.loadResources(packRoots);
                this.resourcePack = resourcePack;
            }
            catch (IOException | RuntimeException e) {
                throw new ConfigurationException("Failed to parse resources!\nIs one of your resource-packs corrupted?", e);
            }
        }
        return this.resourcePack;
    }

    public synchronized DataPack loadDataPack(Path worldFolder) throws ConfigurationException, InterruptedException {
        MinecraftVersion minecraftVersion = this.getOrLoadMinecraftVersion();
        Path vanillaDataPack = minecraftVersion.getDataPack();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        List<Path> worldPacks = List.of();
        Path worldPacksFolder = worldFolder.resolve("datapacks");
        if (Files.isDirectory(worldPacksFolder, new LinkOption[0])) {
            try (Stream<Path> worldPacksStream = Files.list(worldPacksFolder);){
                worldPacks = worldPacksStream.toList();
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to access the worlds datapacks folder.", e);
            }
        }
        Deque<Path> packRoots = this.getPackRoots(worldPacks);
        packRoots.addLast(vanillaDataPack);
        try {
            DataPack datapack = new DataPack(minecraftVersion.getDataPackVersion());
            datapack.loadResources(packRoots);
            return datapack;
        }
        catch (IOException | RuntimeException e) {
            throw new ConfigurationException("Failed to parse resources!\nIs one of your resource-packs corrupted?", e);
        }
    }

    private synchronized Deque<Path> getPackRoots(Path ... additionalRoots) throws ConfigurationException, InterruptedException {
        return this.getPackRoots(List.of(additionalRoots));
    }

    private synchronized Deque<Path> getPackRoots(Iterable<Path> additionalRoots) throws ConfigurationException, InterruptedException {
        Stream<Path> packFiles;
        @Nullable Path packsFolder = this.config.getPacksFolder();
        @Nullable Path modsFolder = this.config.getModsFolder();
        try {
            FileHelper.createDirectories(packsFolder, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ConfigurationException("BlueMap failed to create this folder:\n" + String.valueOf(packsFolder) + "\nDoes BlueMap have sufficient permissions?", ex);
        }
        Path resourceExtensionsFile = this.config.getCoreConfig().getData().resolve("resourceExtensions.zip");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            Files.deleteIfExists(resourceExtensionsFile);
            FileHelper.createDirectories(resourceExtensionsFile.getParent(), new FileAttribute[0]);
            URL resourceExtensionsUrl = Objects.requireNonNull(Plugin.class.getResource("/de/bluecolored/bluemap/resourceExtensions.zip"));
            FileHelper.copy(resourceExtensionsUrl, resourceExtensionsFile);
        }
        catch (IOException ex) {
            throw new ConfigurationException("Failed to create resourceExtensions.zip!\nDoes BlueMap has sufficient write permissions?", ex);
        }
        LinkedList<Path> packRoots = new LinkedList<Path>();
        if (packsFolder != null && Files.isDirectory(packsFolder, new LinkOption[0])) {
            try {
                packFiles = Files.list(packsFolder);
                try {
                    packFiles.sorted(Comparator.reverseOrder()).forEach(packRoots::add);
                }
                finally {
                    if (packFiles != null) {
                        packFiles.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to access packs folder.", e);
            }
        }
        additionalRoots.forEach(packRoots::add);
        if (this.config.getCoreConfig().isScanForModResources() && modsFolder != null && Files.isDirectory(modsFolder, new LinkOption[0])) {
            try {
                packFiles = Files.list(modsFolder);
                try {
                    packFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().endsWith(".jar")).forEach(packRoots::add);
                }
                finally {
                    if (packFiles != null) {
                        packFiles.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to access packs folder.", e);
            }
        }
        packRoots.add(resourceExtensionsFile);
        return packRoots;
    }

    public synchronized MinecraftVersion getOrLoadMinecraftVersion() throws ConfigurationException {
        if (this.minecraftVersion == null) {
            try {
                this.minecraftVersion = MinecraftVersion.load(this.config.getMinecraftVersion(), this.config.getCoreConfig().getData(), this.config.getCoreConfig().isAcceptDownload());
            }
            catch (IOException ex) {
                if (!this.config.getCoreConfig().isAcceptDownload()) {
                    throw new MissingResourcesException();
                }
                throw new ConfigurationException("BlueMap was not able to download some important resources!\nMake sure BlueMap is able to connect to mojang-servers (%s).".formatted("https://piston-meta.mojang.com/"), ex);
            }
        }
        return this.minecraftVersion;
    }

    public BlueMapConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        for (Storage storage : this.storages.values()) {
            try {
                if (storage == null) continue;
                storage.close();
            }
            catch (IOException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

