/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import de.bluecolored.bluemap.api.markers.Marker;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MarkerSet {
    private String label;
    private boolean toggleable;
    private boolean defaultHidden;
    private int sorting;
    private final ConcurrentHashMap<String, Marker> markers;

    private MarkerSet() {
        this("");
    }

    public MarkerSet(String label) {
        this(label, true, false);
    }

    public MarkerSet(String label, boolean toggleable, boolean defaultHidden) {
        this.label = Objects.requireNonNull(label);
        this.toggleable = toggleable;
        this.defaultHidden = defaultHidden;
        this.sorting = 0;
        this.markers = new ConcurrentHashMap();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = Objects.requireNonNull(label);
    }

    public boolean isToggleable() {
        return this.toggleable;
    }

    public void setToggleable(boolean toggleable) {
        this.toggleable = toggleable;
    }

    public boolean isDefaultHidden() {
        return this.defaultHidden;
    }

    public void setDefaultHidden(boolean defaultHidden) {
        this.defaultHidden = defaultHidden;
    }

    public int getSorting() {
        return this.sorting;
    }

    public void setSorting(int sorting) {
        this.sorting = sorting;
    }

    public Map<String, Marker> getMarkers() {
        return this.markers;
    }

    public Marker get(String key) {
        return this.getMarkers().get(key);
    }

    public Marker put(String key, Marker marker) {
        return this.getMarkers().put(key, marker);
    }

    public Marker remove(String key) {
        return this.getMarkers().remove(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerSet markerSet = (MarkerSet)o;
        if (this.toggleable != markerSet.toggleable) {
            return false;
        }
        if (this.defaultHidden != markerSet.defaultHidden) {
            return false;
        }
        if (!this.label.equals(markerSet.label)) {
            return false;
        }
        return this.markers.equals(markerSet.markers);
    }

    public int hashCode() {
        int result = this.label.hashCode();
        result = 31 * result + (this.toggleable ? 1 : 0);
        result = 31 * result + (this.defaultHidden ? 1 : 0);
        result = 31 * result + this.markers.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String label;
        private Boolean toggleable;
        private Boolean defaultHidden;
        private Integer sorting;

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder toggleable(Boolean toggleable) {
            this.toggleable = toggleable;
            return this;
        }

        public Builder defaultHidden(Boolean defaultHidden) {
            this.defaultHidden = defaultHidden;
            return this;
        }

        public Builder sorting(Integer sorting) {
            this.sorting = sorting;
            return this;
        }

        public MarkerSet build() {
            MarkerSet markerSet = new MarkerSet(this.checkNotNull(this.label, "label"));
            if (this.toggleable != null) {
                markerSet.setToggleable(this.toggleable);
            }
            if (this.defaultHidden != null) {
                markerSet.setDefaultHidden(this.defaultHidden);
            }
            if (this.sorting != null) {
                markerSet.setSorting(this.sorting);
            }
            return markerSet;
        }

        <O> O checkNotNull(O object, String name) {
            if (object == null) {
                throw new IllegalStateException(name + " has to be set and cannot be null");
            }
            return object;
        }
    }
}

