/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands.parsers;

import de.bluecolored.bluecommands.CommandParseException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.SimpleSuggestion;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluecommands.parsers.SimpleArgumentParser;
import java.util.List;

public class BooleanArgumentParser<C>
extends SimpleArgumentParser<C, Boolean> {
    private static final List<Suggestion> SUGGESTIONS = List.of(new SimpleSuggestion("true"), new SimpleSuggestion("false"));

    private BooleanArgumentParser() {
        super(false, false);
    }

    @Override
    public Boolean parse(C context, String string) throws CommandParseException {
        if (string.equals("true")) {
            return Boolean.TRUE;
        }
        if (string.equals("false")) {
            return Boolean.FALSE;
        }
        throw new CommandParseException("'" + string + "' is not a valid boolean");
    }

    @Override
    public List<Suggestion> suggest(C context, InputReader input) {
        return SUGGESTIONS;
    }

    public static <C> BooleanArgumentParser<C> create() {
        return new BooleanArgumentParser<C>();
    }
}

