/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands.brigadier;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseMatch;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluecommands.brigadier.CommandExecutionHandler;
import java.util.Comparator;

public class DefaultExecutionHandler<C, T>
implements CommandExecutionHandler<C, T> {
    private static final Message DEFAULT_FAILURE_MESSAGE = () -> "Unknown or incomplete command!";

    @Override
    public int handle(ParseResult<C, T> parseResult) throws CommandSyntaxException {
        Object executionResult;
        if (parseResult.getMatches().isEmpty()) {
            return this.handleParseFailure(parseResult);
        }
        ParseMatch executable = parseResult.getMatches().stream().max(Comparator.comparing(ParseMatch::getPriority)).orElseThrow(IllegalStateException::new);
        try {
            executionResult = executable.execute();
        }
        catch (Exception exception) {
            return this.handleExecutionException(executable.getContext(), exception);
        }
        return this.handleExecution(executable.getContext(), executionResult);
    }

    public int handleParseFailure(ParseResult<C, T> result) throws CommandSyntaxException {
        ParseFailure failure = result.getFailures().stream().max(Comparator.comparing(ParseFailure::getPosition)).orElseThrow(() -> new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(DEFAULT_FAILURE_MESSAGE), DEFAULT_FAILURE_MESSAGE));
        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(failure::getReason), failure::getReason, result.getInput(), failure.getPosition());
    }

    public int handleExecution(C context, T result) {
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return 1;
    }

    public int handleExecutionException(C context, Throwable throwable) {
        throw new RuntimeException(throwable);
    }
}

