/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ParseResult<C, T> {
    private final C context;
    private final String input;
    private final Collection<ParseMatch<C, T>> matches;
    private final Collection<ParseFailure<C, T>> failures;

    public ParseResult(C context, String input) {
        this.context = context;
        this.input = input;
        this.matches = new ArrayList<ParseMatch<C, T>>();
        this.failures = new ArrayList<ParseFailure<C, T>>();
    }

    public C getContext() {
        return this.context;
    }

    public String getInput() {
        return this.input;
    }

    public Collection<ParseMatch<C, T>> getMatches() {
        return Collections.unmodifiableCollection(this.matches);
    }

    void addMatch(ParseMatch<C, T> match) {
        this.matches.add(match);
    }

    public Collection<ParseFailure<C, T>> getFailures() {
        return Collections.unmodifiableCollection(this.failures);
    }

    void addFailure(ParseFailure<C, T> failure) {
        this.failures.add(failure);
    }
}

