/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.ParseData;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.SimpleSuggestion;
import java.util.Collections;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class LiteralCommand<C, T>
extends Command<C, T> {
    private static final Pattern PATTERN = Pattern.compile("\\S*");
    private final String literal;

    public LiteralCommand(String literal) {
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    void parse(ParseData<C, T> data) {
        C context = data.getContext();
        if (!this.isValid(context)) {
            return;
        }
        InputReader input = data.getInput();
        MatchResult match = input.read(PATTERN);
        if (match == null || !match.group().equals(this.literal)) {
            data.getResult().addFailure(new ParseFailure<C, T>(data.getCurrentSegment().getPosition(), match == null ? "Unknown or incomplete command." : String.format("Unknown or incomplete command, got '%s' but expected something else.", match.group()), data.getCommandStack(), Collections.singletonList(new SimpleSuggestion(this.literal))));
        } else {
            super.parse(data);
        }
    }

    @Override
    public boolean isEqual(Command<C, T> other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return ((LiteralCommand)other).literal.equals(this.literal);
    }
}

