/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class Tooltip
extends AbstractTextElement {
    public static final int DEFAULT_MAX_WIDTH = 208;
    public static final int DEFAULT_MAX_HEIGHT = 1000000;
    private static final int CURSOR_BOX_SIZE = 12;
    private static final int Z_OFFSET = 200;
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int BORDER_COLOR_A = 0x505000FF;
    private static final int BORDER_COLOR_B = 1344798847;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    protected boolean autoWidth = true;
    protected boolean autoHeight = true;
    protected int maxWidth = 208;
    protected int maxHeight = 1000000;

    @Deprecated
    public Tooltip() {
        super(Alignment.TOP_LEFT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true, true);
        this.init();
    }

    public Tooltip(PaneParams params) {
        super(params, Alignment.TOP_LEFT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true, true);
        this.autoWidth = this.width == 0;
        this.autoHeight = this.height == 0;
        this.init();
    }

    protected void init() {
        this.textLinespace = 1;
        this.textOffsetX = 4;
        this.textOffsetY = 4;
        this.hide();
        this.recalcTextRendering();
    }

    @Override
    protected void recalcTextRendering() {
        if (this.textScale <= 0.0 || this.isTextEmpty()) {
            this.preparedText = Collections.emptyList();
            return;
        }
        if (this.autoWidth) {
            this.textWidth = this.maxWidth - 8 + 1;
        }
        if (this.autoHeight) {
            this.textHeight = this.maxHeight - 8;
        }
        super.recalcTextRendering();
    }

    @Override
    public void setSize(int w, int h) {
        this.autoWidth = w == 0;
        this.autoHeight = h == 0;
        super.setSize(w, h);
    }

    @Override
    public void drawSelf(BOGuiGraphics ms, double mx, double my) {
    }

    @Override
    public void drawSelfLast(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.pose();
        if (!this.preparedText.isEmpty() && this.isEnabled()) {
            int maxAbsoluteMy;
            int absoluteY;
            this.recalcPreparedTextBox();
            if (this.autoWidth) {
                this.width = this.renderedTextWidth + 8;
            }
            if (this.autoHeight) {
                this.height = this.renderedTextHeight + 8;
            }
            BOScreen scr = this.window.getScreen();
            double renderScale = scr.getRenderScale();
            int marginOffset = 4;
            this.x = (int)mx + 12;
            this.y = Math.max(4, (int)my - 12);
            if ((double)(scr.getAbsoluteMouseX() + 12) * scr.getVanillaGuiScale() > (double)scr.getFramebufferWidth() - renderScale * (double)(this.width + 4)) {
                int guiToWindowOffset = (int)((double)scr.getFramebufferWidth() - (double)scr.width * renderScale) / 2;
                this.x = Math.max(4 - guiToWindowOffset, this.x - 24 - this.width);
            }
            if ((absoluteY = (int)((double)(scr.getAbsoluteMouseY() - 12) * scr.getVanillaGuiScale())) > (maxAbsoluteMy = scr.getFramebufferHeight() - (int)(renderScale * (double)(this.height + 4)))) {
                this.y = (int)((double)this.y - (double)(absoluteY - maxAbsoluteMy) / renderScale);
            }
            ms.pushPose();
            ms.translate((float)this.x, (float)this.y, 200.0f);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f mat = ms.last().pose();
            int bg_a = 240;
            int bg_r = 16;
            boolean bg_g = false;
            int bg_b = 16;
            buffer.addVertex(mat, 1.0f, 1.0f, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, 0.0f, 1.0f, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, 0.0f, (float)(this.height - 1), 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, 1.0f, (float)(this.height - 1), 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, 1.0f, (float)this.height, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, (float)(this.width - 1), (float)this.height, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, (float)(this.width - 1), (float)(this.height - 1), 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, (float)this.width, (float)(this.height - 1), 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, (float)this.width, 1.0f, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, (float)(this.width - 1), 1.0f, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, (float)(this.width - 1), 0.0f, 0.0f).setColor(16, 0, 16, 240);
            buffer.addVertex(mat, 1.0f, 0.0f, 0.0f).setColor(16, 0, 16, 240);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferUploader.drawWithShader((MeshData)buffer.build());
            Tooltip.drawLineRectGradient(ms, 1, 1, this.width - 2, this.height - 2, 0x505000FF, 1344798847, 1);
            RenderSystem.disableBlend();
            ms.translate((double)(-this.x), (double)(-this.y), 0.0);
            super.innerDrawSelf(target, mx, my);
            ms.popPose();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean isPointInPane(double mx, double my) {
        return false;
    }

    public static final class AutomaticTooltip
    extends Tooltip {
    }
}

