/*
 * Decompiled with CFR 0.152.
 */
package hibi.blahaj.block;

import hibi.blahaj.BlahajDataComponentTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class CuddlyItem
extends BlockItem {
    private final Component subtitle;
    public static final ResourceLocation MINING_SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"blahaj", (String)"base_attack_damage");

    public CuddlyItem(Block block, Item.Properties settings, String subtitle) {
        super(block, settings);
        this.subtitle = subtitle == null ? null : Component.translatable((String)subtitle).withStyle(ChatFormatting.GRAY);
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
        super.onCraftedBy(stack, world, player);
        if (player != null) {
            stack.set(BlahajDataComponentTypes.OWNER, (Object)player.getName());
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Component ownerName;
        super.appendHoverText(stack, context, tooltip, type);
        if (this.subtitle != null) {
            tooltip.add(this.subtitle);
        }
        if ((ownerName = (Component)stack.get(BlahajDataComponentTypes.OWNER)) != null) {
            @Nullable Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            if (customName == null) {
                tooltip.add((Component)Component.translatable((String)"tooltip.blahaj.owner.craft", (Object[])new Object[]{ownerName}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.blahaj.owner.rename", (Object[])new Object[]{customName, ownerName}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public static ItemAttributeModifiers createAttributeModifiers() {
        return ItemAttributeModifiers.builder().add(Attributes.BLOCK_BREAK_SPEED, new AttributeModifier(MINING_SPEED_MODIFIER_ID, -3.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, -2.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND).build();
    }
}

