/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod.fabric;

import com.google.common.collect.Sets;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.util.VersionUtil;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.fabric.CustomValueUtil;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Tuple;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricMod
implements Mod {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | FabricMod");
    protected final net.fabricmc.loader.api.ModContainer container;
    protected final ModContainer forgeContainer;
    protected final ModMetadata metadata;
    protected final Mod.ModMenuData modMenuData;
    protected final Set<ModBadge> badges;
    protected final Set<String> badgeNames = new LinkedHashSet<String>();
    protected final Map<String, String> links = new HashMap<String, String>();
    protected boolean defaultIconWarning = true;
    protected boolean allowsUpdateChecks = true;
    protected boolean childHasUpdate = false;

    public FabricMod(String modId) {
        boolean isGenerated;
        this.container = (net.fabricmc.loader.api.ModContainer)FabricLoader.getInstance().getModContainer(modId).get();
        this.forgeContainer = (ModContainer)ModList.get().getModContainerById(modId).get();
        this.metadata = this.container.getMetadata();
        this.badgeNames.add("sinytra_fabric");
        String id = this.metadata.getId();
        Optional<String> parentId = Optional.empty();
        Mod.ModMenuData.DummyParentData parentData = null;
        CustomValue modMenuValue = this.metadata.getCustomValue("modmenu");
        if (modMenuValue != null && modMenuValue.getType() == CustomValue.CvType.OBJECT) {
            CustomValue.CvObject modMenuObject = modMenuValue.getAsObject();
            CustomValue parentCv = modMenuObject.get("parent");
            if (parentCv != null) {
                if (parentCv.getType() == CustomValue.CvType.STRING) {
                    parentId = Optional.of(parentCv.getAsString().replace("-", "_"));
                } else if (parentCv.getType() == CustomValue.CvType.OBJECT) {
                    try {
                        CustomValue.CvObject parentObj = parentCv.getAsObject();
                        parentId = Optional.of(CustomValueUtil.getString("id", parentObj).orElseThrow(() -> new RuntimeException("Parent object lacks an id")).replace("-", "_"));
                        parentData = new Mod.ModMenuData.DummyParentData(parentId.get(), CustomValueUtil.getString("name", parentObj), CustomValueUtil.getString("description", parentObj), CustomValueUtil.getString("icon", parentObj), CustomValueUtil.getStringSet("badges", parentObj).orElse(new HashSet()));
                        if (parentId.orElse("").equals(id)) {
                            parentId = Optional.empty();
                            parentData = null;
                            throw new RuntimeException("Mod declared itself as its own parent");
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error loading parent data from mod: " + id, t);
                    }
                }
            }
            this.badgeNames.addAll(CustomValueUtil.getStringSet("badges", modMenuObject).orElse(new HashSet()));
            ((Map)CustomValueUtil.getStringMap("links", modMenuObject).orElse(new HashMap())).forEach((key, value) -> {
                if (key.startsWith("modmenu")) {
                    key = key.replace("modmenu", "mod_menu");
                }
                this.links.put((String)key, (String)value);
            });
            this.allowsUpdateChecks = CustomValueUtil.getBoolean("update_checker", modMenuObject).orElse(true);
        }
        if ((isGenerated = CustomValueUtil.getBoolean("fabric-loom:generated", this.metadata).orElse(false).booleanValue()) && parentId.isEmpty() && this.container.getContainingMod().isPresent()) {
            net.fabricmc.loader.api.ModContainer inside = (net.fabricmc.loader.api.ModContainer)this.container.getContainingMod().get();
            parentId = Optional.of(inside.getMetadata().getId().replace("-", "_"));
        }
        this.modMenuData = new Mod.ModMenuData(parentId, parentData, id);
        if (this.getId().equals("fabric_language_kotlin")) {
            this.badgeNames.add("library");
        }
        if (this.getId().startsWith("org_jetbrains_kotlin")) {
            this.modMenuData.fillParentIfEmpty("fabric_language_kotlin");
            this.badgeNames.add("library");
        }
        this.badges = this.modMenuData.getBadges();
        if (isGenerated) {
            this.badgeNames.add("library");
        }
        if (this.metadata.getEnvironment() == ModEnvironment.CLIENT) {
            this.badgeNames.add("client");
        }
    }

    @Override
    public Optional<ModContainer> getContainer() {
        return Optional.of(this.forgeContainer);
    }

    @Override
    @NotNull
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    @NotNull
    public Tuple<DynamicTexture, Dimension> getIcon(NeoforgeIconHandler iconHandler, int i, boolean isSmall) {
        ModContainer iconSource;
        Tuple<DynamicTexture, Dimension> icon;
        String iconSourceId = this.getId();
        String iconResourceId = iconSourceId + (isSmall ? "_small" : "");
        if (NeoforgeIconHandler.modResourceIconCache.containsKey(iconResourceId)) {
            return NeoforgeIconHandler.modResourceIconCache.get(iconResourceId);
        }
        String iconPath = (String)((Object)this.metadata.getIconPath(i).orElse("assets/" + this.getId() + "/icon.png"));
        if (isSmall) {
            iconPath = iconPath.replace(".png", "_small.png");
        }
        if ((icon = iconHandler.createIcon(iconSource = (ModContainer)ModList.get().getModContainerById(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id " + iconSourceId)), iconPath)) == null && !isSmall) {
            if (this.defaultIconWarning) {
                LOGGER.warn("Warning! Mod {} has a broken icon, loading default icon", (Object)this.metadata.getId());
                this.defaultIconWarning = false;
            }
            return iconHandler.createIcon((ModContainer)ModList.get().getModContainerById("mod_menu").orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id mod_menu")), "assets/mod_menu/unknown_icon.png");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    @NotNull
    public String getTranslatedDescription() {
        return Mod.super.getTranslatedDescription();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.metadata.getVersion().getFriendlyString();
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        return VersionUtil.getPrefixedVersion(this.getVersion());
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        return this.metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getContributors() {
        LinkedHashMap<String, Collection<String>> contributors = new LinkedHashMap<String, Collection<String>>();
        for (Person contributor : this.metadata.getContributors()) {
            contributors.put(contributor.getName(), List.of("Contributor"));
        }
        return contributors;
    }

    @Override
    @NotNull
    public SortedMap<String, Set<String>> getCredits() {
        TreeMap<String, Set<String>> credits = new TreeMap<String, Set<String>>();
        List<String> authors = this.getAuthors();
        Map<String, Collection<String>> contributors = this.getContributors();
        for (String string : authors) {
            contributors.put(string, List.of("Author"));
        }
        for (Map.Entry entry : contributors.entrySet()) {
            for (String role : (Collection)entry.getValue()) {
                credits.computeIfAbsent(role, key -> new LinkedHashSet());
                ((Set)credits.get(role)).add((String)entry.getKey());
            }
        }
        return credits;
    }

    @Override
    @NotNull
    public Set<ModBadge> getBadges() {
        return this.badges;
    }

    @Override
    @NotNull
    public Set<String> getBadgeNames() {
        return this.badgeNames;
    }

    @Override
    @Nullable
    public String getWebsite() {
        return this.metadata.getContact().get("homepage").orElse(null);
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return this.metadata.getContact().get("issues").orElse(null);
    }

    @Override
    @Nullable
    public String getSource() {
        return this.metadata.getContact().get("sources").orElse(null);
    }

    @Override
    @Nullable
    public String getParent() {
        return this.modMenuData.getParent().orElse(null);
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        return Sets.newHashSet((Iterable)this.metadata.getLicense());
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public Mod.ModMenuData getModMenuData() {
        return this.modMenuData;
    }

    @Override
    public boolean getChildHasUpdate() {
        return this.childHasUpdate;
    }

    @Override
    public void setChildHasUpdate() {
        this.childHasUpdate = true;
    }

    @Override
    public boolean isHidden() {
        return ((List)ModMenu.getConfig().HIDDEN_MODS.get()).contains(this.getId());
    }
}

