/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.gui.widget.ModListWidget;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildParentEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ParentEntry;
import com.terraformersmc.mod_menu.util.DrawingUtil;
import com.terraformersmc.mod_menu.util.ModMenuScreenTexts;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadgeRenderer;
import java.awt.Dimension;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.fml.ModContainer;

public class ModListEntry
extends ObjectSelectionList.Entry<ModListEntry> {
    public static final ResourceLocation UNKNOWN_ICON = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png");
    private static final ResourceLocation MOD_CONFIGURATION_ICON = ResourceLocation.fromNamespaceAndPath((String)"mod_menu", (String)"textures/gui/mod_configuration.png");
    private static final ResourceLocation ERROR_ICON = ResourceLocation.withDefaultNamespace((String)"world_list/error");
    private static final ResourceLocation ERROR_HIGHLIGHTED_ICON = ResourceLocation.withDefaultNamespace((String)"world_list/error_highlighted");
    protected final Minecraft client;
    public final Mod mod;
    protected final ModListWidget list;
    protected Tuple<ResourceLocation, Dimension> iconLocation;
    protected Tuple<ResourceLocation, Dimension> smallIconLocation;
    public static final int FULL_ICON_SIZE = 32;
    public static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = Minecraft.getInstance();
    }

    public Component getNarration() {
        return Component.literal((String)this.mod.getTranslatedName());
    }

    public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        MutableComponent name;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, guiGraphics, x, y, iconSize, iconSize);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        if (((Dimension)this.getIconTexture().getB()).height == ((Dimension)this.getIconTexture().getB()).width) {
            guiGraphics.blit((ResourceLocation)this.getIconTexture().getA(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else if (((Dimension)this.getSquareIconTexture().getB()).height == ((Dimension)this.getSquareIconTexture().getB()).width) {
            guiGraphics.blit((ResourceLocation)this.getSquareIconTexture().getA(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else {
            guiGraphics.blit((ResourceLocation)this.getSquareIconTexture().getA(), (int)((float)x + (float)(iconSize - ((Dimension)this.getSquareIconTexture().getB()).width) / 2.0f), (int)((float)y + (float)(iconSize - ((Dimension)this.getSquareIconTexture().getB()).height) / 2.0f), 0.0f, 0.0f, ((Dimension)this.getSquareIconTexture().getB()).width, ((Dimension)this.getSquareIconTexture().getB()).height, ((Dimension)this.getSquareIconTexture().getB()).width, ((Dimension)this.getSquareIconTexture().getB()).height);
        }
        RenderSystem.disableBlend();
        MutableComponent trimmedName = name = Component.literal((String)this.mod.getTranslatedName());
        int maxNameWidth = rowWidth - iconSize - 3;
        Font font = this.client.font;
        if (font.width((FormattedText)name) > maxNameWidth) {
            FormattedText ellipsis = FormattedText.of((String)"...");
            trimmedName = FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, maxNameWidth - font.width(ellipsis)), ellipsis});
        }
        guiGraphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)trimmedName), x + iconSize + 3, y + 1, 0xFFFFFF, true);
        int updateBadgeXOffset = 0;
        if (!((Boolean)ModMenu.getConfig().HIDE_BADGES.get()).booleanValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.width((FormattedText)name) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(guiGraphics);
        }
        if (!((Boolean)ModMenu.getConfig().COMPACT_LIST.get()).booleanValue()) {
            String summary = this.mod.getSummary();
            Objects.requireNonNull(this.client.font);
            DrawingUtil.drawWrappedString(guiGraphics, summary, x + iconSize + 3 + 4, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            String string = this.mod.getPrefixedVersion();
            Objects.requireNonNull(this.client.font);
            DrawingUtil.drawWrappedString(guiGraphics, string, x + iconSize + 3, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
        if (!(this instanceof ParentEntry) && !(this instanceof ChildParentEntry) && ((Boolean)ModMenu.getConfig().QUICK_CONFIGURE.get()).booleanValue() && (this.list.getParent().getModHasConfigScreen(this.mod.getContainer()) || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 152 : 256;
            if (((Boolean)this.client.options.touchscreen().get()).booleanValue() || hovered) {
                boolean hoveringIcon;
                guiGraphics.fill(x, y, x + iconSize, y + iconSize, -1601138544);
                boolean bl = hoveringIcon = mouseX - x < iconSize;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    guiGraphics.blitSprite(hoveringIcon ? ERROR_HIGHLIGHTED_ICON : ERROR_ICON, x, y, iconSize, iconSize);
                    if (hoveringIcon) {
                        Throwable e = this.list.getParent().modScreenErrors.get(modId);
                        this.list.getParent().setTooltipForNextRenderPass(this.client.font.split((FormattedText)ModMenuScreenTexts.configureError(modId, e), 175));
                    }
                } else {
                    int v = hoveringIcon ? iconSize : 0;
                    guiGraphics.blit(MOD_CONFIGURATION_ICON, x, y, 0.0f, (float)v, iconSize, iconSize, textureSize, textureSize);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int delta) {
        this.list.select(this);
        if (((Boolean)ModMenu.getConfig().QUICK_CONFIGURE.get()).booleanValue() && this.list.getParent().getModHasConfigScreen(this.mod.getContainer())) {
            int iconSize;
            int n = iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
            if (mouseX - (double)this.list.getRowLeft() <= (double)(iconSize + this.getXOffset())) {
                this.openConfig();
            } else if (Util.getMillis() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = Util.getMillis();
        return true;
    }

    public void openConfig() {
        this.mod.getContainer().ifPresent(container -> this.list.getParent().safelyOpenConfigScreen((ModContainer)container));
    }

    public Mod getMod() {
        return this.mod;
    }

    public Tuple<ResourceLocation, Dimension> getIconTexture() {
        if (ModMenu.shouldResetCache) {
            this.smallIconLocation = null;
            this.iconLocation = null;
            ModMenu.shouldResetCache = false;
        }
        if (this.iconLocation == null) {
            this.iconLocation = new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"mod_menu", (String)(this.mod.getId() + "_icon")), (Object)new Dimension());
            Tuple<DynamicTexture, Dimension> icon = this.mod.getIcon(this.list.getNeoforgeIconHandler(), 64 * (Integer)this.client.options.guiScale().get(), false);
            if (icon != null) {
                float multiplier = 32.0f / (float)((Dimension)icon.getB()).height;
                this.iconLocation.setB((Object)new Dimension((int)((float)((Dimension)icon.getB()).width * multiplier), (int)((float)((Dimension)icon.getB()).height * multiplier)));
                this.client.getTextureManager().register((ResourceLocation)this.iconLocation.getA(), (AbstractTexture)icon.getA());
            } else {
                this.iconLocation.setA((Object)UNKNOWN_ICON);
            }
        }
        return this.iconLocation;
    }

    public Tuple<ResourceLocation, Dimension> getSquaredIconTexture() {
        Tuple icon = new Tuple((Object)((ResourceLocation)this.getIconTexture().getA()), (Object)((Dimension)this.iconLocation.getB()).getSize());
        float iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19.0f : 32.0f;
        float biggerValue = Math.max(((Dimension)icon.getB()).width, ((Dimension)icon.getB()).height);
        ((Dimension)icon.getB()).setSize((float)((Dimension)icon.getB()).width / biggerValue * iconSize, (float)((Dimension)icon.getB()).height / biggerValue * iconSize);
        return icon;
    }

    public Tuple<ResourceLocation, Dimension> getSquareIconTexture() {
        if (this.smallIconLocation == null) {
            this.smallIconLocation = new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"mod_menu", (String)(this.mod.getId() + "_icon_small")), (Object)new Dimension());
            Tuple<DynamicTexture, Dimension> icon = this.mod.getIcon(this.list.getNeoforgeIconHandler(), 64 * (Integer)this.client.options.guiScale().get(), true);
            if (icon != null) {
                this.smallIconLocation.setB((Object)new Dimension());
                this.client.getTextureManager().register((ResourceLocation)this.smallIconLocation.getA(), (AbstractTexture)icon.getA());
            } else {
                this.smallIconLocation = this.getSquaredIconTexture();
            }
        }
        return this.smallIconLocation;
    }

    public int getXOffset() {
        return 0;
    }

    public String toString() {
        return "ModListEntry{mod_id=\"" + this.getMod().getId() + "\"}";
    }
}

