/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.compat.EnhancedCelestialsSharedCompatImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class EnhancedCelestials1CompatImpl
extends EnhancedCelestialsSharedCompatImpl {
    private final Class<?> classWorldData;
    private final Method getLunarContext;
    private final Method getLunarForecast;
    private final LunarForecastMethods lunarForecastMethods;
    private final LunarEventMethods lunarEventMethods;
    private final ResourceKey<?> defaultLunarEvent;

    public EnhancedCelestials1CompatImpl(boolean devPackage) {
        try {
            String prefix = devPackage ? "dev." : "";
            this.classWorldData = Class.forName(prefix + "corgitaco.enhancedcelestials.EnhancedCelestialsWorldData");
            Class<?> classDefaultEvents = Class.forName(prefix + "corgitaco.enhancedcelestials.api.lunarevent.DefaultLunarEvents");
            Class<?> classLunarForecast = Class.forName(prefix + "corgitaco.enhancedcelestials.lunarevent.LunarForecast");
            Class<?> classContext = Class.forName(prefix + "corgitaco.enhancedcelestials.core.EnhancedCelestialsContext");
            Class<?> classLunarEvent = Class.forName(prefix + "corgitaco.enhancedcelestials.api.lunarevent.LunarEvent");
            Class<?> classClientSettings = Class.forName(prefix + "corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings");
            Class<?> classColorSettings = Class.forName(prefix + "corgitaco.enhancedcelestials.api.client.ColorSettings");
            this.getLunarContext = this.classWorldData.getMethod("getLunarContext", new Class[0]);
            this.getLunarForecast = classContext.getMethod("getLunarForecast", new Class[0]);
            this.defaultLunarEvent = (ResourceKey)classDefaultEvents.getField("DEFAULT").get(null);
            this.lunarForecastMethods = new LunarForecastMethods(classLunarForecast.getMethod("lastLunarEvent", new Class[0]), classLunarForecast.getMethod("currentLunarEvent", new Class[0]), classLunarForecast.getMethod("getBlend", new Class[0]), classLunarForecast.getMethod("switchingEvents", new Class[0]));
            this.lunarEventMethods = new LunarEventMethods(classLunarEvent.getMethod("getClientSettings", new Class[0]), classClientSettings.getMethod("colorSettings", new Class[0]), classColorSettings.getMethod("getGLSkyLightColor", new Class[0]), classClientSettings.getMethod("moonSize", new Class[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected EnhancedCelestialsSharedCompatImpl.LunarForecastAccess getLunarForecast(Level world) {
        if (!this.classWorldData.isInstance(world)) {
            return null;
        }
        try {
            Object ctx = this.getLunarContext.invoke((Object)world, new Object[0]);
            if (ctx == null) {
                return null;
            }
            Object forecast = this.getLunarForecast.invoke(ctx, new Object[0]);
            return new LunarForecastAccessImpl(forecast, this.lunarForecastMethods, this.lunarEventMethods);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Your versions of Better Clouds and EnhancedCelestials are not compatible!", e);
        }
    }

    @Override
    protected ResourceLocation defaultLunarEvent() {
        return this.defaultLunarEvent.location();
    }

    private record LunarForecastMethods(Method lastLunarEvent, Method currentLunarEvent, Method getBlend, Method switchingEvents) {
    }

    private record LunarEventMethods(Method getClientSettings, Method colorSettings, Method getGLSkyLightColor, Method moonSize) {
    }

    private static class LunarForecastAccessImpl
    extends EnhancedCelestialsSharedCompatImpl.LunarForecastAccess {
        private final Object instance;
        private final LunarForecastMethods methods;
        private final LunarEventMethods eventMethods;

        public LunarForecastAccessImpl(Object instance, LunarForecastMethods methods, LunarEventMethods eventMethods) {
            this.instance = instance;
            this.methods = methods;
            this.eventMethods = eventMethods;
        }

        @Override
        public EnhancedCelestialsSharedCompatImpl.LunarEventAccess lastLunarEvent() {
            return new LunarEventAccessImpl((Holder)this.invoke(this.instance, this.methods.lastLunarEvent, new Object[0]), this.eventMethods);
        }

        @Override
        public EnhancedCelestialsSharedCompatImpl.LunarEventAccess currentLunarEvent() {
            return new LunarEventAccessImpl((Holder)this.invoke(this.instance, this.methods.currentLunarEvent, new Object[0]), this.eventMethods);
        }

        @Override
        public float getBlend() {
            return ((Float)this.invoke(this.instance, this.methods.getBlend, new Object[0])).floatValue();
        }

        @Override
        public boolean switchingEvents() {
            return (Boolean)this.invoke(this.instance, this.methods.switchingEvents, new Object[0]);
        }
    }

    private static class LunarEventAccessImpl
    extends EnhancedCelestialsSharedCompatImpl.LunarEventAccess {
        private final Holder<?> entry;
        private final LunarEventMethods methods;

        private LunarEventAccessImpl(Holder<?> entry, LunarEventMethods methods) {
            this.entry = entry;
            this.methods = methods;
        }

        private Object getClientSettings() {
            return this.invoke(this.entry.value(), this.methods.getClientSettings, new Object[0]);
        }

        @Override
        public Vector3f getGLSkyLightColor() {
            Object clientSettings = this.getClientSettings();
            Object colorSettings = this.invoke(clientSettings, this.methods.colorSettings, new Object[0]);
            return (Vector3f)this.invoke(colorSettings, this.methods.getGLSkyLightColor, new Object[0]);
        }

        @Override
        public float getMoonSize() {
            Object clientSettings = this.getClientSettings();
            return ((Float)this.invoke(clientSettings, this.methods.moonSize, new Object[0])).floatValue();
        }

        @Override
        protected boolean matches(ResourceLocation id) {
            return this.entry.is(id);
        }
    }
}

