/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.util.RenderHelper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL32;

public class Debug {
    public static int profileInterval = 0;
    public static boolean frustumCulling = false;
    public static boolean generatorPause = false;
    public static int animationPause = -1;
    public static boolean generatorForceUpdate = false;
    public static final List<Tuple<AABB, Boolean>> frustumCulledBoxes = new ArrayList<Tuple<AABB, Boolean>>();
    private static BuiltBufferRenderer renderer = null;

    private static void clearFrustumCulledBoxes() {
        if (frustumCulling) {
            frustumCulledBoxes.clear();
        } else if (!frustumCulledBoxes.isEmpty()) {
            frustumCulledBoxes.clear();
        }
    }

    public static void addFrustumCulledBox(AABB box, boolean visible) {
        if (!frustumCulling) {
            return;
        }
        frustumCulledBoxes.add((Tuple<AABB, Boolean>)new Tuple((Object)box, (Object)visible));
    }

    public static void render(Resources res, Vector3d cam) {
        if (!frustumCulling) {
            Debug.clearFrustumCulledBoxes();
            return;
        }
        if (frustumCulledBoxes.isEmpty()) {
            return;
        }
        if (renderer == null) {
            renderer = new BuiltBufferRenderer();
        }
        GLCompat.glCompat.pushDebugGroupDev("Debug Draw");
        BufferBuilder vertices = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        Debug.drawFrustumCulledBoxes((VertexConsumer)vertices, cam);
        res.debugShader().bind();
        res.debugShader().uModelViewMatrix.setMat4(RenderHelper.getViewMatrix());
        res.debugShader().uProjectionMatrix.setMat4(RenderHelper.getProjectionMatrix());
        MeshData built = vertices.build();
        if (built != null) {
            ByteBuffer vertexBuffer = built.vertexBuffer();
            int vertexCount = built.drawState().vertexCount();
            renderer.render(vertexBuffer, vertexCount);
            built.close();
        }
        Debug.clearFrustumCulledBoxes();
        GLCompat.glCompat.popDebugGroup();
    }

    private static void drawFrustumCulledBoxes(VertexConsumer vertices, Vector3d cam) {
        for (Tuple<AABB, Boolean> pair : frustumCulledBoxes) {
            AABB box = (AABB)pair.getA();
            if (((Boolean)pair.getB()).booleanValue()) {
                Debug.drawBox(cam, vertices, box, 0.6f, 1.0f, 0.5f, 1.0f);
                continue;
            }
            Debug.drawBox(cam, vertices, box, 1.0f, 0.6f, 0.5f, 1.0f);
        }
    }

    public static void drawBox(Vector3d cam, VertexConsumer vertices, AABB box, float red, float green, float blue, float alpha) {
        float minX = (float)(box.minX - cam.x);
        float minY = (float)(box.minY - cam.y);
        float minZ = (float)(box.minZ - cam.z);
        float maxX = (float)(box.maxX - cam.x);
        float maxY = (float)(box.maxY - cam.y);
        float maxZ = (float)(box.maxZ - cam.z);
        Debug.addLine(vertices, minX, minY, minZ, maxX, minY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, maxZ, maxX, minY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, maxY, maxZ, maxX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, maxY, minZ, maxX, maxY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, minZ, minX, maxY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, maxZ, minX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, minY, maxZ, maxX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, minY, minZ, maxX, maxY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, minZ, minX, minY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, maxY, minZ, minX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, maxY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, minY, minZ, maxX, minY, maxZ, red, green, blue, alpha);
    }

    private static void addLine(VertexConsumer vertices, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        float nx = x2 - x1;
        float ny = y2 - y1;
        float nz = z2 - z1;
        float l = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        Debug.addVertex(vertices, x1, y1, z1, nx /= l, ny /= l, nz /= l, red, green, blue, alpha);
        Debug.addVertex(vertices, x2, y2, z2, nx, ny, nz, red, green, blue, alpha);
    }

    private static void addVertex(VertexConsumer vertexConsumer, float x, float y, float z, float nx, float ny, float nz, float red, float green, float blue, float alpha) {
        vertexConsumer.addVertex(x, y, z).setColor(red, green, blue, alpha);
    }

    public static boolean isProfilingEnabled() {
        return profileInterval > 0;
    }

    private static class BuiltBufferRenderer {
        private final int vboId;
        private int vboSize = 0;
        private final int vaoId;

        public BuiltBufferRenderer() {
            int prevVao = GL32.glGetInteger((int)34229);
            this.vaoId = GL32.glGenVertexArrays();
            GL32.glBindVertexArray((int)this.vaoId);
            GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_VERTEX_ARRAY, this.vaoId, "debug_vao");
            GL32.glEnableVertexAttribArray((int)0);
            GL32.glEnableVertexAttribArray((int)1);
            this.vboId = GL32.glGenBuffers();
            GL32.glBindBuffer((int)34962, (int)this.vboId);
            GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.vboId, "debug_vbo");
            GL32.glBindBuffer((int)34962, (int)0);
            GL32.glBindVertexArray((int)prevVao);
        }

        public void render(ByteBuffer buffer, int vertexCount) {
            if (buffer.remaining() == 0) {
                return;
            }
            int prevVao = GL32.glGetInteger((int)34229);
            GL32.glBindVertexArray((int)this.vaoId);
            GL32.glBindBuffer((int)34962, (int)this.vboId);
            if (buffer.remaining() > this.vboSize) {
                this.vboSize = buffer.remaining();
                GL32.glBufferData((int)34962, (ByteBuffer)buffer, (int)35040);
                int stride = 16;
                GL32.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
                GL32.glVertexAttribPointer((int)1, (int)4, (int)5121, (boolean)true, (int)stride, (long)12L);
            } else {
                GL32.glBufferSubData((int)34962, (long)0L, (ByteBuffer)buffer);
            }
            GL32.glDrawArrays((int)1, (int)0, (int)vertexCount);
            GL32.glBindVertexArray((int)prevVao);
        }
    }
}

