/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.container.CachedBankStorage;
import net.natte.bankstorage.item.BankItem;
import net.natte.bankstorage.item.LinkItem;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.options.SortMode;
import net.natte.bankstorage.state.BankStateManager;
import net.natte.bankstorage.util.HugeItemStack;
import net.natte.bankstorage.util.KeyBindInfo;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static Supplier<Boolean> isShiftDown = () -> false;
    public static KeyBindInfo keybindInfo = new KeyBindInfo(false, false);
    public static Random clientSyncedRandom;
    public static final ThreadLocal<Boolean> isClient;

    public static boolean isBank(ItemStack itemStack) {
        return itemStack.getItem() instanceof BankItem;
    }

    public static boolean isLink(ItemStack itemStack) {
        return itemStack.getItem() instanceof LinkItem;
    }

    public static boolean isBankLike(ItemStack itemStack) {
        return Util.isBank(itemStack) || Util.isLink(itemStack);
    }

    public static boolean isDisallowedInBank(ItemStack itemStack) {
        return !itemStack.getItem().canFitInsideContainerItems();
    }

    public static boolean hasUUID(ItemStack itemStack) {
        return itemStack.has(BankStorage.UUIDComponentType);
    }

    public static UUID getUUID(ItemStack itemStack) {
        return (UUID)itemStack.get(BankStorage.UUIDComponentType);
    }

    public static BankType getType(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BankItem) {
            BankItem bankItem = (BankItem)item;
            return bankItem.getType();
        }
        return (BankType)stack.getOrDefault(BankStorage.BankTypeComponentType, (Object)BankStorage.BANK_TYPES[0]);
    }

    public static BankOptions getOrCreateOptions(ItemStack itemStack) {
        BankOptions options = (BankOptions)itemStack.get(BankStorage.OptionsComponentType);
        if (options == null) {
            options = BankOptions.create();
            Util.setOptions(itemStack, options);
        }
        return options;
    }

    public static void setOptions(ItemStack itemStack, BankOptions options) {
        itemStack.set(BankStorage.OptionsComponentType, (Object)options);
    }

    public static void sortBank(BankItemStorage bankItemStorage, ServerPlayer player, SortMode sortMode) {
        ArrayList<HugeItemStack> collectedItems = new ArrayList<HugeItemStack>();
        for (int i = 0; i < bankItemStorage.size(); ++i) {
            ItemStack itemStack = bankItemStorage.getItems().get(i);
            bankItemStorage.getItems().set(i, ItemStack.EMPTY);
            boolean didExist = false;
            for (HugeItemStack existing : collectedItems) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)existing.stack)) continue;
                existing.count += (long)itemStack.getCount();
                didExist = true;
                break;
            }
            if (didExist || itemStack.isEmpty()) continue;
            collectedItems.add(new HugeItemStack(itemStack.copyWithCount(1), itemStack.getCount()));
        }
        switch (sortMode) {
            case COUNT: {
                collectedItems.sort(Comparator.comparingLong(HugeItemStack::getCount).reversed());
                break;
            }
            case NAME: {
                collectedItems.sort(Comparator.comparing(HugeItemStack::getName));
                break;
            }
            case MOD: {
                collectedItems.sort(Comparator.comparing(HugeItemStack::getModName));
            }
        }
        int slotSize = bankItemStorage.getMaxCountPerStack();
        for (HugeItemStack collectedItem : collectedItems) {
            bankItemStorage.getLockedSlots().keySet().stream().filter(index -> ItemStack.isSameItemSameComponents((ItemStack)collectedItem.stack, (ItemStack)bankItemStorage.getLockedStack((int)index))).sorted().forEach(index -> bankItemStorage.getItems().set((int)index, collectedItem.split(slotSize)));
        }
        for (HugeItemStack collectedItem : collectedItems) {
            if (collectedItem.count == 0L) continue;
            for (int i = 0; i < bankItemStorage.size(); ++i) {
                ItemStack existingStack;
                if (bankItemStorage.getLockedStack(i) != null || !(existingStack = bankItemStorage.getItems().get(i)).isEmpty()) continue;
                bankItemStorage.getItems().set(i, collectedItem.split(slotSize));
            }
        }
        for (HugeItemStack collectedItem : collectedItems) {
            while (collectedItem.count > 0L) {
                BankStorage.LOGGER.warn("Item does not fit in bank after sort. This *should* be impossible. item: {} count: {}", (Object)collectedItem.stack, (Object)collectedItem.count);
                player.getInventory().placeItemBackInInventory(collectedItem.split(collectedItem.stack.getMaxStackSize()));
            }
        }
    }

    public static BankItemStorage getBankItemStorage(UUID uuid) {
        return BankStateManager.getState().get(uuid);
    }

    @Nullable
    public static BankItemStorage getBankItemStorage(ItemStack bank) {
        UUID uuid;
        UUID uUID = uuid = Util.isBank(bank) ? Util.getOrSetUUID(bank) : Util.getUUID(bank);
        if (uuid == null) {
            return null;
        }
        BankType type = Util.getType(bank);
        BankItemStorage bankItemStorage = BankStateManager.getState().getOrCreate(uuid, type);
        bank.set(BankStorage.BankTypeComponentType, (Object)bankItemStorage.type());
        if (bankItemStorage.type() != type && Util.isLink(bank)) {
            bank.set(BankStorage.BankTypeComponentType, (Object)bankItemStorage.type());
        }
        return bankItemStorage;
    }

    public static UUID getOrSetUUID(ItemStack bank) {
        UUID uuid = (UUID)bank.get(BankStorage.UUIDComponentType);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            bank.set(BankStorage.UUIDComponentType, (Object)uuid);
        }
        return uuid;
    }

    public static ResourceLocation ID(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"bankstorage", (String)path);
    }

    public static IItemHandler getItemHandlerFromItem(ItemStack itemStack, Void ignored) {
        if (Util.isClient()) {
            return Util.getClientItemHandlerFromItem(itemStack);
        }
        return Util.getServerItemHandlerFromItem(itemStack);
    }

    private static IItemHandler getClientItemHandlerFromItem(ItemStack itemStack) {
        CachedBankStorage cachedBankStorage = CachedBankStorage.getBankStorage(itemStack);
        if (cachedBankStorage == null) {
            return null;
        }
        return cachedBankStorage.getReadOnlyItemHandler();
    }

    private static IItemHandler getServerItemHandlerFromItem(ItemStack itemStack) {
        BankItemStorage bankItemStorage = Util.getBankItemStorage(itemStack);
        if (bankItemStorage == null) {
            return null;
        }
        return bankItemStorage.getItemHandler(Util.getPickupMode(itemStack));
    }

    public static PickupMode getPickupMode(ItemStack itemStack) {
        return ((BankOptions)itemStack.getOrDefault(BankStorage.OptionsComponentType, (Object)BankOptions.DEFAULT)).pickupMode();
    }

    public static boolean isClient() {
        return isClient.get();
    }

    public static boolean isBuildModeToggleKeyBound(Player player) {
        return (player.level().isClientSide() ? keybindInfo : (KeyBindInfo)player.getData(BankStorage.KEYBIND_INFO_ATTACHMENT)).hasBuildModeToggleKey();
    }

    public static boolean isBuildModeCycleKeyBound(Player player) {
        return (player.level().isClientSide() ? keybindInfo : (KeyBindInfo)player.getData(BankStorage.KEYBIND_INFO_ATTACHMENT)).hasBuildModeCycleKey();
    }

    static {
        isClient = ThreadLocal.withInitial(() -> false);
    }
}

