/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.state;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.natte.bankstorage.state.BankPersistentState;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

public class BankStateManager {
    public static final SavedData.Factory<BankPersistentState> TYPE = new SavedData.Factory(BankPersistentState::new, BankPersistentState::createFromNbt, null);
    private static BankPersistentState INSTANCE;

    public static void initialize(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        DimensionDataStorage persistentStateManager = server.overworld().getDataStorage();
        INSTANCE = (BankPersistentState)persistentStateManager.computeIfAbsent(TYPE, "bankstorage");
    }

    public static BankPersistentState getState() {
        INSTANCE.setDirty();
        return INSTANCE;
    }

    public static void markDirty() {
        BankStateManager.getState().setDirty();
    }
}

