/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.screen;

import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.packet.screensync.LockedSlotsPacketS2C;
import net.natte.bankstorage.screen.BankScreenHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BankScreenHandlerSyncHandler
implements ContainerSynchronizer {
    private final ContainerSynchronizer screenHandlerSyncHandler;
    private final ServerPlayer player;

    public BankScreenHandlerSyncHandler(ContainerSynchronizer original, ServerPlayer player) {
        this.screenHandlerSyncHandler = original;
        this.player = player;
    }

    public void syncLockedSlots(AbstractContainerMenu screenHandler, Map<Integer, ItemStack> lockedSlots) {
        PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new LockedSlotsPacketS2C(screenHandler.containerId, lockedSlots), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendInitialData(AbstractContainerMenu screenHandler, NonNullList<ItemStack> items, ItemStack carriedItem, int[] initialData) {
        this.screenHandlerSyncHandler.sendInitialData(screenHandler, items, carriedItem, initialData);
        this.syncLockedSlots(screenHandler, ((BankScreenHandler)screenHandler).getLockedSlots());
    }

    public void sendSlotChange(AbstractContainerMenu screenHandler, int slot, ItemStack itemStack) {
        this.screenHandlerSyncHandler.sendSlotChange(screenHandler, slot, itemStack);
    }

    public void sendCarriedChange(AbstractContainerMenu screenHandlerMenu, ItemStack itemStack) {
        this.screenHandlerSyncHandler.sendCarriedChange(screenHandlerMenu, itemStack);
    }

    public void sendDataChange(AbstractContainerMenu screenHandler, int property, int value) {
        this.screenHandlerSyncHandler.sendDataChange(screenHandler, property, value);
    }
}

