/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.screen;

import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.blockentity.BankDockBlockEntity;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.inventory.BankSlot;
import net.natte.bankstorage.inventory.LockedSlot;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.packet.NetworkUtil;
import net.natte.bankstorage.screen.BankScreenHandlerSyncHandler;
import net.natte.bankstorage.util.Util;
import org.jetbrains.annotations.Nullable;

public class BankScreenHandler
extends AbstractContainerMenu {
    public final Container inventory;
    private final BankType type;
    private final BankItemStorage bankItemStorage;
    @Nullable
    final UUID uuid;
    private final ContainerLevelAccess context;
    public BankScreenHandlerSyncHandler bankScreenSync;
    private final ItemStack bankLikeItem;
    private final int slotWithOpenedBank;
    private final ServerPlayer player;
    private short lockedSlotsRevision = 0;

    public ItemStack getBankLikeItem() {
        return this.bankLikeItem;
    }

    public BankScreenHandler(int syncId, @Nullable ServerPlayer player, Inventory playerInventory, BankType type, ItemStack bankItem, int slot, BankItemStorage bankItemStorage, ContainerLevelAccess context) {
        super(BankStorage.MENU_TYPE, syncId);
        int x;
        this.player = player;
        this.context = context;
        this.bankLikeItem = bankItem;
        this.bankItemStorage = bankItemStorage;
        this.inventory = bankItemStorage.getContainer();
        this.slotWithOpenedBank = slot;
        BankScreenHandler.checkContainerSize((Container)this.inventory, (int)type.size());
        this.type = type;
        this.uuid = bankItemStorage.uuid();
        this.inventory.startOpen(playerInventory.player);
        int rows = this.type.rows;
        int cols = this.type.cols;
        for (int y = 0; y < rows; ++y) {
            for (x = 0; x < cols; ++x) {
                int slotIndex = x + y * cols;
                this.addSlot(new BankSlot(this.inventory, slotIndex, 8 + x * 18, 18 + y * 18, this.type.stackLimit, bankItemStorage.getLockedStack(slotIndex)));
            }
        }
        int inventoryY = 32 + rows * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                if (x2 + y * 9 + 9 == this.slotWithOpenedBank) {
                    this.addSlot(new LockedSlot((Container)playerInventory, x2 + y * 9 + 9, 8 + x2 * 18, inventoryY + y * 18));
                    continue;
                }
                this.addSlot(new Slot((Container)playerInventory, x2 + y * 9 + 9, 8 + x2 * 18, inventoryY + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            if (x == this.slotWithOpenedBank) {
                this.addSlot(new LockedSlot((Container)playerInventory, x, 8 + x * 18, inventoryY + 58));
                continue;
            }
            this.addSlot(new Slot((Container)playerInventory, x, 8 + x * 18, inventoryY + 58));
        }
    }

    public boolean stillValid(Player player) {
        if (!AbstractContainerMenu.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)BankStorage.BANK_DOCK_BLOCK.get()))) {
            return false;
        }
        if (this.bankItemStorage.isOutDated()) {
            return false;
        }
        return (Boolean)this.context.evaluate((world, pos) -> {
            BlockEntity patt0$temp = world.getBlockEntity(pos);
            if (!(patt0$temp instanceof BankDockBlockEntity)) {
                return false;
            }
            BankDockBlockEntity blockEntity = (BankDockBlockEntity)patt0$temp;
            if (!blockEntity.hasBank()) {
                return false;
            }
            if (!blockEntity.getBank().has(BankStorage.UUIDComponentType)) {
                return false;
            }
            if (!((UUID)blockEntity.getBank().get(BankStorage.UUIDComponentType)).equals(this.uuid)) {
                return false;
            }
            return true;
        }, (Object)true);
    }

    public ContainerLevelAccess getContext() {
        return this.context;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.insertItemToPlayer(originalStack, this.inventory.getContainerSize(), this.slots.size()) : !this.insertIntoBank(originalStack)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    private boolean insertIntoBank(ItemStack stack) {
        if (Util.isDisallowedInBank(stack)) {
            return false;
        }
        ItemStack notInserted = this.bankItemStorage.getItemHandler(PickupMode.ALL).insertItem(stack);
        stack.setCount(notInserted.getCount());
        return notInserted.getCount() != stack.getCount();
    }

    private boolean insertItemToPlayer(ItemStack stack, int startIndex, int endIndex) {
        ItemStack itemStack;
        Slot slot;
        int i;
        boolean bl = false;
        if (stack.isStackable()) {
            for (i = endIndex - 1; !stack.isEmpty() && i >= startIndex; --i) {
                slot = (Slot)this.slots.get(i);
                int maxStackCount = slot.getMaxStackSize(stack);
                itemStack = slot.getItem();
                if (itemStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) continue;
                int j = itemStack.getCount() + stack.getCount();
                if (j <= maxStackCount) {
                    stack.setCount(0);
                    itemStack.setCount(j);
                    slot.setChanged();
                    bl = true;
                    continue;
                }
                if (itemStack.getCount() >= maxStackCount) continue;
                stack.shrink(maxStackCount - itemStack.getCount());
                itemStack.setCount(maxStackCount);
                slot.setChanged();
                bl = true;
            }
        }
        if (!stack.isEmpty()) {
            for (i = endIndex - 1; i >= startIndex; --i) {
                slot = (Slot)this.slots.get(i);
                itemStack = slot.getItem();
                if (!itemStack.isEmpty() || !slot.mayPlace(stack)) continue;
                slot.setByPlayer(stack.split(Math.min(slot.getMaxStackSize(), Math.min(stack.getCount(), stack.getMaxStackSize()))));
                slot.setChanged();
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        if (actionType == ClickType.SWAP) {
            if (!((Slot)this.slots.get(slotIndex)).mayPickup(player) || button == this.slotWithOpenedBank) {
                return;
            }
            ItemStack stackInSlot = ((Slot)this.slots.get(slotIndex)).getItem();
            if (stackInSlot.getCount() > stackInSlot.getMaxStackSize()) {
                return;
            }
        }
        super.clicked(slotIndex, button, actionType, player);
        if (this.uuid != null) {
            NetworkUtil.syncCachedBankS2C(this.uuid, (ServerPlayer)player);
        }
    }

    public boolean tryItemClickBehaviourOverride(Player player, ClickAction clickAction, Slot slot, ItemStack stack, ItemStack cursorStack) {
        if (stack.getCount() > stack.getMaxStackSize()) {
            return false;
        }
        return super.tryItemClickBehaviourOverride(player, clickAction, slot, stack, cursorStack);
    }

    public void removed(Player player) {
        if (this.uuid != null) {
            NetworkUtil.syncCachedBankS2C(this.uuid, (ServerPlayer)player);
        }
        super.removed(player);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.bankScreenSync == null) {
            return;
        }
        if (this.bankItemStorage.getLockedSlotsRevision() != this.lockedSlotsRevision) {
            this.setLockedSlotsNoSync(this.bankItemStorage.getLockedSlots());
            this.bankScreenSync.syncLockedSlots(this, this.bankItemStorage.getLockedSlots());
            this.lockedSlotsRevision = this.bankItemStorage.getLockedSlotsRevision();
        }
    }

    public void setSynchronizer(ContainerSynchronizer synchronizer) {
        this.bankScreenSync = new BankScreenHandlerSyncHandler(synchronizer, this.player);
        super.setSynchronizer((ContainerSynchronizer)this.bankScreenSync);
    }

    public void lockSlot(int index, ItemStack stack) {
        boolean canLock;
        if (index < 0 || index >= this.slots.size()) {
            return;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (!(slot instanceof BankSlot)) {
            return;
        }
        BankSlot bankSlot = (BankSlot)slot;
        boolean bl = canLock = slot.getItem().isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)stack);
        if (!canLock) {
            return;
        }
        bankSlot.lock(stack);
        this.bankItemStorage.lockSlot(index, stack);
    }

    public void unlockSlot(int index) {
        if (index < 0 || index >= this.slots.size()) {
            return;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (!(slot instanceof BankSlot)) {
            return;
        }
        BankSlot bankSlot = (BankSlot)slot;
        bankSlot.unlock();
        this.bankItemStorage.unlockSlot(index);
    }

    public void setLockedSlotsNoSync(Map<Integer, ItemStack> lockedSlots) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (!(slot instanceof BankSlot)) continue;
            BankSlot bankSlot = (BankSlot)slot;
            ItemStack stack = lockedSlots.get(i);
            if (stack == null) {
                this.bankItemStorage.unlockSlot(i);
                bankSlot.unlock();
                continue;
            }
            this.bankItemStorage.lockSlot(i, stack);
            bankSlot.lock(stack);
        }
    }

    public void lockedSlotsMarkDirty() {
        this.bankItemStorage.updateLockedSlotsRevision();
    }

    public BankType getBankType() {
        return this.type;
    }

    public Map<Integer, ItemStack> getLockedSlots() {
        return this.bankItemStorage.getLockedSlots();
    }

    public BankItemStorage getBankItemStorage() {
        return this.bankItemStorage;
    }
}

