/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.item;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.item.BankFunctionality;
import net.natte.bankstorage.util.Util;

public class LinkItem
extends BankFunctionality {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.US);

    public LinkItem(Item.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (Util.isShiftDown.get().booleanValue() && Util.hasUUID(stack)) {
            tooltip.add((Component)Component.literal((String)Util.getUUID(stack).toString()).withStyle(ChatFormatting.DARK_AQUA));
        }
        BankType type = Util.getType(stack);
        MutableComponent formattedStackLimit = Component.literal((String)NUMBER_FORMAT.format(type.stackLimit));
        tooltip.add((Component)Component.translatable((String)"tooltip.bankstorage.stacklimit", (Object[])new Object[]{formattedStackLimit}));
        tooltip.add((Component)Component.translatable((String)"tooltip.bankstorage.numslots", (Object[])new Object[]{Component.literal((String)String.valueOf(type.size()))}));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

