/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.inventory;

import com.google.common.collect.Iterables;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.packet.NetworkUtil;
import net.natte.bankstorage.packet.client.ItemStackBobbingAnimationPacketS2C;
import net.natte.bankstorage.util.Util;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemPickupHandler {
    public static boolean pickUpStack(ItemStack pickedUpStack, Inventory playerInventory) {
        Level world = playerInventory.player.level();
        if (world.isClientSide) {
            return false;
        }
        if (pickedUpStack.isEmpty()) {
            return false;
        }
        if (Util.isDisallowedInBank(pickedUpStack)) {
            return false;
        }
        int index = -1;
        Iterable items = Iterables.concat((Iterable)playerInventory.items, (Iterable)playerInventory.armor, (Iterable)playerInventory.offhand);
        for (ItemStack itemStack : items) {
            BankItemStorage bankItemStorage;
            ++index;
            if (!Util.isBankLike(itemStack)) continue;
            boolean bankPickedUpAny = false;
            if (!itemStack.has(BankStorage.UUIDComponentType) || (bankItemStorage = Util.getBankItemStorage(itemStack)) == null) continue;
            PickupMode mode = ((BankOptions)itemStack.getOrDefault(BankStorage.OptionsComponentType, (Object)BankOptions.DEFAULT)).pickupMode();
            ItemStack notPickedUp = bankItemStorage.getItemHandler(mode).insertItem(pickedUpStack);
            if (notPickedUp.getCount() != pickedUpStack.getCount()) {
                bankPickedUpAny = true;
            }
            pickedUpStack.setCount(notPickedUp.getCount());
            if (bankPickedUpAny) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)playerInventory.player), (CustomPacketPayload)new ItemStackBobbingAnimationPacketS2C(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
                NetworkUtil.syncCachedBankS2C(bankItemStorage.uuid(), (ServerPlayer)playerInventory.player);
            }
            if (!pickedUpStack.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

