/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.inventory;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.util.Util;
import org.jetbrains.annotations.Nullable;

public class BankSlot
extends Slot {
    private final int stackLimit;
    @Nullable
    private ItemStack lockedStack = null;
    private boolean isActive = true;

    public BankSlot(Container inventory, int index, int x, int y, int stackLimit) {
        super(inventory, index, x, y);
        this.stackLimit = stackLimit;
    }

    public BankSlot(Container inventory, int index, int x, int y, int stackLimit, @Nullable ItemStack lockedStack) {
        this(inventory, index, x, y, stackLimit);
        if (lockedStack != null) {
            this.lockedStack = lockedStack;
        }
    }

    public void lock(ItemStack stack) {
        this.lockedStack = stack.copyWithCount(1);
    }

    public void unlock() {
        this.lockedStack = null;
    }

    public boolean isLocked() {
        return this.lockedStack != null;
    }

    @Nullable
    public ItemStack getLockedStack() {
        return this.lockedStack;
    }

    public boolean mayPlace(ItemStack stack) {
        if (this.lockedStack != null && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.lockedStack)) {
            return false;
        }
        if (Util.isDisallowedInBank(stack)) {
            return false;
        }
        return super.mayPlace(stack);
    }

    public int getMaxStackSize() {
        return this.stackLimit;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.stackLimit;
    }

    public void setByPlayer(ItemStack stack) {
        this.container.setItem(this.getSlotIndex(), stack);
    }

    public Optional<ItemStack> tryRemove(int min, int max, Player player) {
        if (!this.mayPickup(player)) {
            return Optional.empty();
        }
        if (!this.allowModification(player) && max < this.getItem().getCount()) {
            return Optional.empty();
        }
        int stackMaxCount = this.getItem().getMaxStackSize();
        ItemStack itemStack = this.remove(Math.min(Math.min(min, max), stackMaxCount));
        if (itemStack.isEmpty()) {
            return Optional.empty();
        }
        if (this.getItem().isEmpty()) {
            this.setByPlayer(ItemStack.EMPTY);
        }
        return Optional.of(itemStack);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

