/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.container;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.container.ClientReadOnlyItemHandler;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.BuildMode;
import net.natte.bankstorage.util.Util;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CachedBankStorage {
    public static final StreamCodec<RegistryFriendlyByteBuf, CachedBankStorage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, o -> o.items, (StreamCodec)UUIDUtil.STREAM_CODEC, o -> o.uuid, (StreamCodec)ByteBufCodecs.SHORT, o -> o.revision, CachedBankStorage::new);
    private static final Map<UUID, CachedBankStorage> BANK_CACHE = new HashMap<UUID, CachedBankStorage>();
    public static final Set<UUID> bankRequestQueue = new HashSet<UUID>();
    private static final Map<UUID, Integer> throddledQueue = new HashMap<UUID, Integer>();
    private static Consumer<UUID> requestCacheUpdate = uuid -> {};
    public static boolean markDirtyForPreview = false;
    private final List<ItemStack> items;
    private final List<ItemStack> nonEmptyItems;
    private final List<ItemStack> blockItems;
    public final UUID uuid;
    public short revision;

    public CachedBankStorage(List<ItemStack> items, UUID uuid, short revision) {
        this.items = items;
        this.uuid = uuid;
        this.revision = revision;
        this.blockItems = items.stream().filter(stack -> stack.getItem() instanceof BlockItem).toList();
        this.nonEmptyItems = items.stream().filter(stack -> !stack.isEmpty()).toList();
    }

    public static void requestCacheUpdate(UUID uuid) {
        requestCacheUpdate.accept(uuid);
    }

    public static void setCacheUpdater(Consumer<UUID> consumer) {
        requestCacheUpdate = consumer;
    }

    @Nullable
    public static CachedBankStorage getAndThrottleUpdate(ItemStack stack, int ticks) {
        if (!Util.hasUUID(stack)) {
            return null;
        }
        UUID uuid = Util.getUUID(stack);
        if (!throddledQueue.containsKey(uuid)) {
            throddledQueue.put(uuid, ticks);
            CachedBankStorage.requestCacheUpdate(uuid);
        }
        return CachedBankStorage.getBankStorage(uuid);
    }

    public static void advanceThrottledQueue() {
        throddledQueue.entrySet().removeIf(entity -> (Integer)entity.getValue() <= 0);
        throddledQueue.replaceAll((uuid, ticksLeft) -> ticksLeft - 1);
    }

    public ItemStack getSelectedItem(int selectedItemSlot) {
        if (this.getBlockItems().isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.getBlockItems().get(Mth.clamp((int)selectedItemSlot, (int)0, (int)(this.getBlockItems().size() - 1)));
    }

    public ItemStack getRandomItem(Random random) {
        if (this.getBlockItems().isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.getBlockItems().get(random.nextInt(this.getBlockItems().size()));
    }

    public ItemStack chooseItemToPlace(BankOptions options, Random random, int selectedSlot) {
        return switch (options.buildMode()) {
            default -> throw new MatchException(null, null);
            case BuildMode.NONE_NORMAL, BuildMode.NONE_RANDOM -> ItemStack.EMPTY;
            case BuildMode.NORMAL -> this.getSelectedItem(selectedSlot);
            case BuildMode.RANDOM -> this.getRandomItem(random);
        };
    }

    @Nullable
    public static CachedBankStorage getBankStorage(ItemStack itemStack) {
        if (!Util.hasUUID(itemStack)) {
            return null;
        }
        UUID uuid = Util.getUUID(itemStack);
        return CachedBankStorage.getBankStorage(uuid);
    }

    @Nullable
    public static CachedBankStorage getBankStorage(UUID uuid) {
        CachedBankStorage bankStorage = BANK_CACHE.get(uuid);
        if (bankStorage == null) {
            CachedBankStorage.requestCacheUpdate(uuid);
        }
        return bankStorage;
    }

    public static void setBankStorage(UUID uuid, CachedBankStorage bankStorage) {
        BANK_CACHE.put(uuid, bankStorage);
        markDirtyForPreview = true;
    }

    public List<ItemStack> getBlockItems() {
        return this.blockItems;
    }

    public List<ItemStack> getNonEmptyItems() {
        return this.nonEmptyItems;
    }

    public IItemHandler getReadOnlyItemHandler() {
        return new ClientReadOnlyItemHandler(this);
    }
}

