/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.command.BankFilter;
import net.natte.bankstorage.command.BankTypeArgumentType;
import net.natte.bankstorage.command.SortingModeArgumentType;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.state.BankStateManager;
import net.natte.bankstorage.util.Util;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RestoreBankCommands {
    private static final Map<UUID, BankFilter> filters = new HashMap<UUID, BankFilter>();
    private static final UUID TERMINAL_UUID = UUID.randomUUID();
    private static final ArgumentTypeInfo<SortingModeArgumentType, ?> SORTING_MODE_ARGUMENT_TYPE = SingletonArgumentInfo.contextFree(SortingModeArgumentType::sortingMode);
    private static final ArgumentTypeInfo<BankTypeArgumentType, ?> BANK_TYPE_ARGUMENT_TYPE = SingletonArgumentInfo.contextFree(BankTypeArgumentType::bankType);

    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bankstorage").requires(context -> context.hasPermission(2))).then(Commands.literal((String)"fromuuid").then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(RestoreBankCommands::restoreBankCommand))))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(RestoreBankCommands::listBankStorages)).then(Commands.literal((String)"sort").then(Commands.argument((String)"sorting_mode", (ArgumentType)SortingModeArgumentType.sortingMode()).executes(RestoreBankCommands::listBankStoragesSorted))))).then(((LiteralArgumentBuilder)Commands.literal((String)"filter").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(RestoreBankCommands::clearFilter)).then(Commands.literal((String)"type").executes(RestoreBankCommands::clearFilterType))).then(Commands.literal((String)"player").executes(RestoreBankCommands::clearPlayerFilter))).then(Commands.literal((String)"item").executes(RestoreBankCommands::clearItemFilter)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"type").then(Commands.argument((String)"type", (ArgumentType)BankTypeArgumentType.bankType()).executes(RestoreBankCommands::addTypeFilter)))).then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(RestoreBankCommands::addPlayerFilter)))).then(Commands.literal((String)"item").then(Commands.argument((String)"itemPredicate", (ArgumentType)ItemPredicateArgument.itemPredicate((CommandBuildContext)event.getBuildContext())).executes(RestoreBankCommands::addItemFilter))))));
    }

    public static void registerArgumentTypes(DeferredRegister<ArgumentTypeInfo<?, ?>> argumentTypeRegister) {
        argumentTypeRegister.register("sorting_mode", () -> SORTING_MODE_ARGUMENT_TYPE);
        argumentTypeRegister.register("bank_type", () -> BANK_TYPE_ARGUMENT_TYPE);
        ArgumentTypeInfos.registerByClass(SortingModeArgumentType.class, SORTING_MODE_ARGUMENT_TYPE);
        ArgumentTypeInfos.registerByClass(BankTypeArgumentType.class, BANK_TYPE_ARGUMENT_TYPE);
    }

    private static int restoreBankCommand(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"admin_restore_bank.bankstorage.unknown_player"));
            return 0;
        }
        UUID uuid = UuidArgument.getUuid(context, (String)"uuid");
        BankItemStorage bank = Util.getBankItemStorage(uuid);
        if (bank == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.bankstorage.unknownid"), false);
            return 0;
        }
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(Util.ID(bank.type().getName()))).getDefaultInstance();
        stack.set(BankStorage.UUIDComponentType, (Object)uuid);
        player.getInventory().add(stack);
        return 1;
    }

    private static int listBankStorages(CommandContext<CommandSourceStack> context) {
        BankFilter filter = RestoreBankCommands.getFilter(context);
        List<BankItemStorage> bankItemStorages = BankStateManager.getState().getBankItemStorages().stream().filter(filter::matchesBank).toList();
        RestoreBankCommands.listBankStoragesInChat(context, bankItemStorages);
        return 1;
    }

    private static int listBankStoragesSorted(CommandContext<CommandSourceStack> context) {
        BankFilter filter = RestoreBankCommands.getFilter(context);
        SortingModeArgumentType.SortingMode sortingMode = SortingModeArgumentType.getSortingMode(context, "sorting_mode");
        Stream<BankItemStorage> bankItemStorages = BankStateManager.getState().getBankItemStorages().stream().filter(filter::matchesBank);
        List<BankItemStorage> sortedBankItemStorages = switch (sortingMode) {
            default -> throw new MatchException(null, null);
            case SortingModeArgumentType.SortingMode.DATE -> bankItemStorages.sorted(Comparator.comparing(bank -> bank.dateCreated)).toList();
            case SortingModeArgumentType.SortingMode.TYPE -> bankItemStorages.sorted(Comparator.comparing(bank -> bank.type().getName())).toList();
            case SortingModeArgumentType.SortingMode.PLAYER -> bankItemStorages.sorted(Comparator.comparing(bank -> bank.usedByPlayerUUID)).toList();
        };
        RestoreBankCommands.listBankStoragesInChat(context, sortedBankItemStorages);
        return 1;
    }

    private static void listBankStoragesInChat(CommandContext<CommandSourceStack> context, List<BankItemStorage> bankItemStorages) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        MutableComponent message = Component.empty();
        for (BankItemStorage bankItemStorage : bankItemStorages) {
            UUID uuid = bankItemStorage.uuid();
            long nonEmptyStacks = bankItemStorage.getItems().stream().filter(stack -> !stack.isEmpty()).count();
            String command = "/bankstorage fromuuid " + uuid.toString() + " " + player.getName().getString();
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"command.bankstorage.hoverinfo"));
            message.append((Component)Component.literal((String)(bankItemStorage.type().getName() + ", " + nonEmptyStacks + " items, uuid: " + bankItemStorage.uuid().toString() + ", " + bankItemStorage.usedByPlayerName + "\n")).withStyle(style -> style.withClickEvent(clickEvent).withHoverEvent(hoverEvent)));
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)message);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.listed_banks_num", (Object[])new Object[]{bankItemStorages.size()}));
    }

    private static BankFilter getFilter(CommandContext<CommandSourceStack> context) {
        UUID uuid = ((CommandSourceStack)context.getSource()).isPlayer() ? ((CommandSourceStack)context.getSource()).getPlayer().getUUID() : TERMINAL_UUID;
        return filters.computeIfAbsent(uuid, ignoredUuid -> new BankFilter());
    }

    private static int clearFilter(CommandContext<CommandSourceStack> context) {
        RestoreBankCommands.getFilter(context).clear();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.cleared_all_filters"));
        return 1;
    }

    private static int clearFilterType(CommandContext<CommandSourceStack> context) {
        RestoreBankCommands.getFilter(context).clearType();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.cleared_type_filters"));
        return 1;
    }

    private static int clearPlayerFilter(CommandContext<CommandSourceStack> context) {
        RestoreBankCommands.getFilter(context).clearPlayers();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.cleared_player_filters"));
        return 1;
    }

    private static int clearItemFilter(CommandContext<CommandSourceStack> context) {
        RestoreBankCommands.getFilter(context).clearItems();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.cleared_item_filters"));
        return 1;
    }

    private static int addTypeFilter(CommandContext<CommandSourceStack> context) {
        RestoreBankCommands.getFilter(context).addType(BankTypeArgumentType.getBankType(context, "type"));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.added_type_filter"));
        return 1;
    }

    private static int addPlayerFilter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        RestoreBankCommands.getFilter(context).addPlayer(EntityArgument.getPlayer(context, (String)"player"));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.added_player_filter"));
        return 1;
    }

    private static int addItemFilter(CommandContext<CommandSourceStack> context) {
        RestoreBankCommands.getFilter(context).addItemPredicate((Predicate<ItemStack>)ItemPredicateArgument.getItemPredicate(context, (String)"itemPredicate"));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"admin_restore_bank.bankstorage.added_item_filter"));
        return 1;
    }
}

