/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.screen;

import java.time.Duration;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.natte.bankstorage.options.SortMode;

public class SortButtonWidget
extends Button {
    public SortMode sortMode;
    private long lastPressedTime;
    private final ResourceLocation texture;
    private int uOffset;

    public SortButtonWidget(SortMode sortMode, int x, int y, int width, int height, ResourceLocation texture, Consumer<SortButtonWidget> pressAction) {
        super(x, y, width, height, CommonComponents.EMPTY, button -> pressAction.accept((SortButtonWidget)button), DEFAULT_NARRATION);
        this.sortMode = sortMode;
        this.lastPressedTime = 0L;
        this.texture = texture;
        this.refreshTooltip();
        this.setTooltipDelay(Duration.ofMillis(700L));
    }

    public void onPress() {
        super.onPress();
        this.uOffset = this.getUOffset();
        this.lastPressedTime = Util.getMillis();
    }

    public long timeSinceLastPressed() {
        return Util.getMillis() - this.lastPressedTime;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.blit(this.texture, this.getX(), this.getY(), (float)this.uOffset, (float)(98 + (this.isHoveredOrFocused() ? this.height : 0)), this.width, this.height, 256, 256);
    }

    private int getUOffset() {
        return switch (this.sortMode) {
            default -> throw new MatchException(null, null);
            case SortMode.COUNT -> 0;
            case SortMode.NAME -> 14;
            case SortMode.MOD -> 28;
        };
    }

    public void refreshTooltip() {
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)("title.bankstorage.sortmode." + this.sortMode.name().toLowerCase())).append((Component)Component.empty().append("\n").append((Component)Component.translatable((String)("tooltip.bankstorage.sortmode." + this.sortMode.name().toLowerCase())).withStyle(ChatFormatting.DARK_GRAY)))));
    }
}

