/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.screen;

import java.time.Duration;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.natte.bankstorage.options.PickupMode;

public class PickupModeButtonWidget
extends Button {
    PickupMode pickupMode;
    private static final int textureWidth = 256;
    private static final int textureHeight = 256;
    private final ResourceLocation texture;
    private int uOffset;

    public PickupModeButtonWidget(PickupMode pickupMode, int x, int y, int width, int height, ResourceLocation texture, Consumer<PickupModeButtonWidget> pressAction) {
        super(x, y, width, height, CommonComponents.EMPTY, button -> pressAction.accept((PickupModeButtonWidget)button), DEFAULT_NARRATION);
        this.texture = texture;
        this.pickupMode = pickupMode;
        this.refreshTooltip();
        this.updateUOffset();
        this.setTooltipDelay(Duration.ofMillis(700L));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.blit(this.texture, this.getX(), this.getY(), 0, (float)this.uOffset, (float)(70 + (this.isHoveredOrFocused() ? this.height : 0)), this.width, this.height, 256, 256);
    }

    public void refreshTooltip() {
        String name = switch (this.pickupMode) {
            default -> throw new MatchException(null, null);
            case PickupMode.NONE -> "no_pickup";
            case PickupMode.ALL -> "pickup_all";
            case PickupMode.FILTERED -> "filtered";
            case PickupMode.VOID -> "void_overflow";
        };
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)("title.bankstorage.pickupmode." + name)).append("\n").append((Component)Component.translatable((String)("tooltip.bankstorage.pickupmode." + name)).withStyle(ChatFormatting.DARK_GRAY))));
    }

    public void nextState() {
        this.pickupMode = this.pickupMode.next();
        this.updateUOffset();
    }

    private void updateUOffset() {
        this.uOffset = switch (this.pickupMode) {
            default -> throw new MatchException(null, null);
            case PickupMode.NONE -> 0;
            case PickupMode.ALL -> 14;
            case PickupMode.FILTERED -> 28;
            case PickupMode.VOID -> 42;
        };
    }
}

