/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.client.BankStorageClient;
import net.natte.bankstorage.client.Resources;
import net.natte.bankstorage.client.rendering.ItemCountUtils;
import net.natte.bankstorage.client.screen.PickupModeButtonWidget;
import net.natte.bankstorage.client.screen.ScrollBarWidget;
import net.natte.bankstorage.client.screen.SortButtonWidget;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.inventory.BankSlot;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.SortMode;
import net.natte.bankstorage.packet.server.LockSlotPacketC2S;
import net.natte.bankstorage.packet.server.PickupModePacketC2S;
import net.natte.bankstorage.packet.server.SortPacketC2S;
import net.natte.bankstorage.screen.BankScreenHandler;
import net.natte.bankstorage.util.Util;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BankScreen
extends AbstractContainerScreen<BankScreenHandler> {
    private static final NumberFormat FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private static final ResourceLocation WIDGETS_TEXTURE = Util.ID("textures/gui/widgets.png");
    private final BankType type;
    private ResourceLocation texture = Resources.NULL_TEXTURE;
    private int guiTextureWidth = 256;
    private int guiTextureHeight = 256;
    private boolean hasScrollBar = false;
    private int visibleRows;
    private int topVisibleRow = 0;
    private SortMode sortMode;
    @Nullable
    private BankSlot currentlyRenderingBankSlot = null;
    private boolean isLockSlotKeyDown;
    private float scrollValue = 0.0f;
    private ScrollBarWidget scrollBar;

    public BankScreen(BankScreenHandler screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
        this.type = screenHandler.getBankType();
    }

    protected void init() {
        this.visibleRows = this.getVisibleRows();
        this.hasScrollBar = this.visibleRows < this.type.rows;
        this.scrollTo(0);
        this.repositionPlayerSlots();
        this.imageWidth = 176;
        this.imageHeight = 114 + this.visibleRows * 18;
        this.texture = Resources.backGround(this.visibleRows);
        this.guiTextureWidth = 256;
        this.guiTextureHeight = Mth.ceil((double)((double)this.imageHeight / 256.0)) * 256;
        this.inventoryLabelY = 20 + this.visibleRows * 18;
        super.init();
        BankOptions options = (BankOptions)((BankScreenHandler)this.menu).getBankLikeItem().getOrDefault(BankStorage.OptionsComponentType, (Object)BankOptions.DEFAULT);
        this.sortMode = options.sortMode();
        this.addRenderableWidget((GuiEventListener)new PickupModeButtonWidget(options.pickupMode(), this.leftPos + this.titleLabelX + this.imageWidth - 49, this.topPos + this.titleLabelY - 4, 14, 14, WIDGETS_TEXTURE, this::onPickupModeButtonPress));
        this.addRenderableWidget((GuiEventListener)new SortButtonWidget(options.sortMode(), this.leftPos + this.titleLabelX + this.imageWidth - 31, this.topPos + this.titleLabelY - 4, 14, 14, WIDGETS_TEXTURE, this::onSortButtonPress));
        this.scrollBar = this.hasScrollBar ? (ScrollBarWidget)this.addRenderableWidget(new ScrollBarWidget(this.leftPos + this.imageWidth - 4, this.topPos, this.type.rows, this.visibleRows, this.scrollValue, this::onScroll)) : null;
    }

    private int getVisibleRows() {
        int heightOf6RowsGui = 222;
        int minimumScreenHeight = 240;
        int screenHeight = this.height;
        int maxRows = (screenHeight - minimumScreenHeight + heightOf6RowsGui - 114) / 18;
        return Mth.clamp((int)maxRows, (int)1, (int)this.type.rows);
    }

    public boolean hasScrollBar() {
        return this.hasScrollBar;
    }

    public int getScrollBarHeight() {
        return this.visibleRows * 18 + 24;
    }

    private void onScroll(float percentage) {
        int hiddenRows = this.type.rows - this.visibleRows;
        int topRow = Mth.clamp((int)Math.round(percentage * (float)hiddenRows), (int)0, (int)hiddenRows);
        this.scrollValue = percentage;
        if (topRow != this.topVisibleRow) {
            this.scrollTo(topRow);
        }
    }

    private void scrollTo(int topRow) {
        this.topVisibleRow = topRow;
        for (int i = 0; i < this.type.size(); ++i) {
            int y = i / 9;
            BankSlot slot = (BankSlot)((BankScreenHandler)this.menu).getSlot(i);
            if (y < this.topVisibleRow || y >= this.topVisibleRow + this.visibleRows) {
                slot.setActive(false);
                continue;
            }
            slot.setActive(true);
            slot.y = 18 + y * 18 - this.topVisibleRow * 18;
        }
    }

    private void repositionPlayerSlots() {
        int inventoryY = 32 + this.visibleRows * 18;
        int i = this.type.size();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((Slot)((BankScreenHandler)this.menu).slots.get((int)i++)).y = inventoryY + y * 18;
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((Slot)((BankScreenHandler)this.menu).slots.get((int)i++)).y = inventoryY + 58;
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.hasScrollBar && this.scrollBar != null && this.scrollBar.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hasScrollBar && this.scrollBar != null && this.scrollBar.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.hasScrollBar && this.scrollBar != null && this.scrollBar.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot slot = this.hoveredSlot;
        if (!(slot instanceof BankSlot)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        BankSlot bankSlot = (BankSlot)slot;
        if (button == 2) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.sendSortPacket();
            return true;
        }
        if (button == 0 && this.isLockSlotKeyDown) {
            this.handleSlotLock(bankSlot);
            this.skipNextRelease = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void handleSlotLock(BankSlot bankSlot) {
        boolean shouldUnLock;
        int hoveredSlotIndex = bankSlot.index;
        ItemStack hoveredStack = bankSlot.getItem();
        ItemStack cursorStack = ((BankScreenHandler)this.menu).getCarried();
        boolean isSlotEmpty = hoveredStack.isEmpty();
        ItemStack lockedStack = bankSlot.getLockedStack();
        boolean bl = shouldUnLock = bankSlot.isLocked() && (cursorStack.isEmpty() || !isSlotEmpty || ItemStack.isSameItemSameComponents((ItemStack)cursorStack, (ItemStack)lockedStack));
        if (shouldUnLock) {
            ((BankScreenHandler)this.menu).unlockSlot(bankSlot.index);
        } else {
            ((BankScreenHandler)this.menu).lockSlot(bankSlot.index, isSlotEmpty ? cursorStack : hoveredStack);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new LockSlotPacketC2S(((BankScreenHandler)this.menu).containerId, hoveredSlotIndex, isSlotEmpty ? cursorStack : hoveredStack, !shouldUnLock), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (BankStorageClient.lockSlotKeyBinding.matches(keyCode, scanCode)) {
            this.isLockSlotKeyDown = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (BankStorageClient.lockSlotKeyBinding.matches(keyCode, scanCode)) {
            this.isLockSlotKeyDown = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
        this.setFocused(null);
    }

    protected void renderBg(GuiGraphics drawContext, float timeDelta, int mouseX, int mouseY) {
        drawContext.blit(this.texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.guiTextureWidth, this.guiTextureHeight);
    }

    public void renderSlot(GuiGraphics context, Slot slot) {
        if (slot instanceof BankSlot) {
            BankSlot bankSlot;
            this.currentlyRenderingBankSlot = bankSlot = (BankSlot)slot;
        }
        super.renderSlot(context, slot);
        this.currentlyRenderingBankSlot = null;
    }

    protected void renderSlotContents(GuiGraphics guiGraphics, ItemStack itemstack, Slot slot, @Nullable String countString) {
        if (this.currentlyRenderingBankSlot == null) {
            super.renderSlotContents(guiGraphics, itemstack, slot, countString);
            return;
        }
        this.renderBankSlot(guiGraphics, this.currentlyRenderingBankSlot, itemstack, countString != null);
    }

    private void renderBankSlot(GuiGraphics context, BankSlot slot, ItemStack stack, boolean drawInYellow) {
        int x = slot.x;
        int y = slot.y;
        int seed = x + y * this.imageWidth;
        if (slot.isLocked()) {
            context.blit(WIDGETS_TEXTURE, x, y, stack.isEmpty() ? 16 : 0, 46, 16, 16);
        }
        context.renderItem(slot.isLocked() ? slot.getLockedStack() : stack, x, y, seed);
        if (slot.isLocked() && stack.isEmpty()) {
            RenderSystem.enableBlend();
            context.blit(WIDGETS_TEXTURE, x, y, 200, 32.0f, 46.0f, 16, 16, 256, 256);
            RenderSystem.disableBlend();
        }
        if (drawInYellow || stack.getCount() > 1) {
            BankScreen.drawItemCount(context, this.font, stack.getCount(), x, y, drawInYellow);
        }
        context.renderItemDecorations(this.font, stack.copyWithCount(1), x, y, null);
    }

    public static void drawItemCount(GuiGraphics context, Font textRenderer, int count, int x, int y, boolean drawInYellow) {
        PoseStack poseStack = context.pose();
        poseStack.pushPose();
        String countString = ItemCountUtils.toConsiseString(count);
        String formattedString = drawInYellow ? String.valueOf(ChatFormatting.YELLOW) + countString : countString;
        float scale = ItemCountUtils.scale();
        int textWidth = textRenderer.width(countString);
        int xOffset = x + 18 - 2;
        int yOffset = y + 18 - 2;
        poseStack.translate((float)xOffset, (float)yOffset, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate((float)(-xOffset), (float)(-yOffset), 0.0f);
        poseStack.translate(0.0f, 0.0f, 200.0f);
        context.drawString(textRenderer, formattedString, x + 18 - 1 - textWidth, y + 9, 0xFFFFFF, true);
        poseStack.popPose();
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List tooltip = super.getTooltipFromContainerItem(stack);
        if (stack.getCount() > 9999) {
            tooltip.add(1, Component.literal((String)FORMAT.format(stack.getCount())).withStyle(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    private void onPickupModeButtonPress(PickupModeButtonWidget button) {
        button.nextState();
        button.refreshTooltip();
        PacketDistributor.sendToServer((CustomPacketPayload)new PickupModePacketC2S(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void onSortButtonPress(SortButtonWidget button) {
        if (button.timeSinceLastPressed() < 1000L) {
            button.sortMode = button.sortMode.next();
        }
        this.sortMode = button.sortMode;
        button.refreshTooltip();
        this.sendSortPacket();
    }

    private void sendSortPacket() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SortPacketC2S(this.sortMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

