/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.client.BankStorageClient;
import net.natte.bankstorage.client.rendering.BuildModePreviewRenderer;
import net.natte.bankstorage.container.CachedBankStorage;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.BuildMode;
import net.natte.bankstorage.packet.server.SelectedSlotPacketC2S;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class MouseEvents {
    public static void onScroll(InputEvent.MouseScrollingEvent event) {
        int scroll = -((int)Math.signum(event.getScrollDeltaY()));
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!MouseEvents.isScrollEnabled(player)) {
            return;
        }
        BuildModePreviewRenderer preview = BankStorageClient.buildModePreviewRenderer;
        if (!preview.hasBank()) {
            return;
        }
        if (!MouseEvents.isNormalBuildMode(preview.getItem())) {
            return;
        }
        CachedBankStorage cachedBankStorage = preview.getStorage();
        if (cachedBankStorage == null) {
            return;
        }
        int selectedItemSlot = preview.selectedSlot;
        int newSelectedItemSlot = Mth.clamp((int)(selectedItemSlot + scroll), (int)0, (int)(cachedBankStorage.getBlockItems().size() - 1));
        if (newSelectedItemSlot != preview.selectedSlot) {
            preview.selectSlot(newSelectedItemSlot);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SelectedSlotPacketC2S(preview.renderingFromHand == InteractionHand.MAIN_HAND, newSelectedItemSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        event.setCanceled(true);
    }

    private static boolean isScrollEnabled(LocalPlayer player) {
        if (BankStorageClient.enableBlockSelectionScrollKeyBinding.isUnbound()) {
            return player.isShiftKeyDown();
        }
        return BankStorageClient.enableBlockSelectionScrollKeyBinding.isDown();
    }

    private static boolean isNormalBuildMode(ItemStack itemStack) {
        BuildMode buildMode = ((BankOptions)itemStack.getOrDefault(BankStorage.OptionsComponentType, (Object)BankOptions.DEFAULT)).buildMode();
        return buildMode == BuildMode.NORMAL;
    }
}

