/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.blay09.mods.balm.neoforge.world.BalmBiomeModifier;
import net.blay09.mods.balm.neoforge.world.BiomeModification;
import net.blay09.mods.balm.neoforge.world.level.biome.internal.NeoForgeBiomeModificationBuilder;
import net.blay09.mods.balm.world.level.biome.BiomeModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class NeoForgeBalmWorldGen
implements BalmWorldGen {
    public static final MapCodec<BalmBiomeModifier> BALM_BIOME_MODIFIER_CODEC = MapCodec.unit((Object)BalmBiomeModifier.INSTANCE);
    private static final List<BiomeModification> legacyBiomeModifications = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<BiomePredicate, BiomeModifier>> biomeModifiers = Collections.synchronizedList(new ArrayList());

    public static void initializeBalmBiomeModifiers(IEventBus modBus) {
        DeferredRegister registry = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"balm");
        registry.register("balm", () -> BALM_BIOME_MODIFIER_CODEC);
        registry.register(modBus);
    }

    @Override
    public <T extends Feature<?>> DeferredObject<T> registerFeature(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(Registries.FEATURE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public <T extends PlacementModifierType<?>> DeferredObject<T> registerPlacementModifier(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(Registries.PLACEMENT_MODIFIER_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public <T extends PoiType> DeferredObject<T> registerPoiType(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(Registries.POINT_OF_INTEREST_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public void addFeatureToBiomes(BiomePredicate biomePredicate, GenerationStep.Decoration step, ResourceLocation placedFeatureIdentifier) {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)placedFeatureIdentifier);
        legacyBiomeModifications.add(new BiomeModification(biomePredicate, step, (ResourceKey<PlacedFeature>)resourceKey));
    }

    @Override
    public void modifyBiome(ResourceLocation id, BiomePredicate predicate, BiomeModifier modifier) {
        biomeModifiers.add((Pair<BiomePredicate, BiomeModifier>)Pair.of((Object)predicate, (Object)modifier));
    }

    public void modifyBiome(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            for (BiomeModification biomeModification : legacyBiomeModifications) {
                ResourceLocation location = biome.unwrapKey().map(ResourceKey::location).orElse(null);
                if (location == null || !biomeModification.getBiomePredicate().test(location, biome)) continue;
                Registry placedFeatures = ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
                placedFeatures.getHolder(biomeModification.getConfiguredFeatureKey()).ifPresent(placedFeature -> builder.getGenerationSettings().addFeature(biomeModification.getStep(), (Holder)placedFeature));
            }
            NeoForgeBiomeModificationBuilder modificationBuilder = new NeoForgeBiomeModificationBuilder(builder);
            for (Pair<BiomePredicate, BiomeModifier> biomeModifierPair : biomeModifiers) {
                ResourceLocation location = biome.unwrapKey().map(ResourceKey::location).orElse(null);
                if (location == null || !((BiomePredicate)biomeModifierPair.getFirst()).test(location, biome)) continue;
                ((BiomeModifier)biomeModifierPair.getSecond()).modifyBiome(biome, modificationBuilder);
            }
        }
    }
}

