/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config.schema.builder;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.blay09.mods.balm.api.config.LenientEnumCodecs;
import net.blay09.mods.balm.api.config.schema.ConfiguredEnum;
import net.blay09.mods.balm.api.config.schema.builder.AbstractConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.ConfigPropertyBuilder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;

public class EnumConfigProperty<T extends Enum<T>>
extends AbstractConfigProperty<T>
implements ConfiguredEnum<T> {
    private final T defaultValue;
    private final Codec<T> codec;
    private final StreamCodec<ByteBuf, T> streamCodec;

    public EnumConfigProperty(ConfigPropertyBuilder parent, T defaultValue) {
        super(parent);
        this.defaultValue = defaultValue;
        Class enumClass = ((Enum)defaultValue).getDeclaringClass();
        IntFunction byIdMapper = ByIdMap.continuous(Enum::ordinal, (Object[])((Enum[])enumClass.getEnumConstants()), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        this.codec = LenientEnumCodecs.fromValues(enumClass::getEnumConstants);
        this.streamCodec = ByteBufCodecs.idMapper((IntFunction)byIdMapper, Enum::ordinal).cast();
    }

    @Override
    public Class<T> type() {
        return ((Enum)this.defaultValue).getDeclaringClass();
    }

    @Override
    public Codec<T> codec() {
        return this.codec;
    }

    @Override
    public StreamCodec<ByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }
}

