/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.neoforge;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import mod.azure.azurelib.AzureLibClient;
import mod.azure.azurelib.common.config.ConfigHolder;
import mod.azure.azurelib.common.config.ConfigHolderRegistry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@EventBusSubscriber(modid="azurelib", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModListener {
    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        Map<String, List<ConfigHolder<?>>> groups = ConfigHolderRegistry.getConfigGroupingByGroup();
        ModList modList = ModList.get();
        for (Map.Entry<String, List<ConfigHolder<?>>> entry : groups.entrySet()) {
            String modId = entry.getKey();
            Optional optional = modList.getModContainerById(modId);
            optional.ifPresent(modContainer -> {
                List list = (List)entry.getValue();
                modContainer.registerExtensionPoint(IConfigScreenFactory.class, () -> (container, screen) -> {
                    if (list.size() == 1) {
                        return AzureLibClient.getConfigScreen(((ConfigHolder)list.get(0)).getConfigId(), screen);
                    }
                    return AzureLibClient.getConfigScreenByGroup(list, modId, screen);
                });
            });
        }
    }
}

