/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.animation.impl.AzItemAnimator;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzProvider;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.item.AzItemGuiRenderUtil;
import mod.azure.azurelib.common.render.item.AzItemRendererConfig;
import mod.azure.azurelib.common.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.common.render.item.AzItemRendererPipelineContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzItemRenderer {
    private final AzItemRendererConfig config;
    private final AzProvider<UUID, ItemStack> provider;
    public final AzItemRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    protected AzItemRenderer(AzItemRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
        this.provider = new AzProvider<UUID, ItemStack>(config::createAnimator, config::modelLocation, animator -> (UUID)animator.get(AzureLib.AZ_ID.get()));
        this.config = config;
    }

    protected AzItemRendererPipeline createPipeline(AzItemRendererConfig config) {
        return new AzItemRendererPipeline(config, this);
    }

    public void renderByGui(ItemStack stack, ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight) {
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzBakedModel model = this.provider.provideBakedModel(context.currentEntity(), stack);
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        AzItemGuiRenderUtil.renderInGui(this.config, this.rendererPipeline, stack, model, stack, poseStack, source, packedLight);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight) {
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzBakedModel model = this.provider.provideBakedModel(context.currentEntity(), stack);
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        ResourceLocation textureLocation = this.config.textureLocation(context.currentEntity(), stack);
        RenderType renderType = this.rendererPipeline.context().getDefaultRenderType(stack, textureLocation, source, partialTick, this.config.getRenderType(context.currentEntity(), stack), this.config.alpha(stack));
        boolean withGlint = stack != null && stack.hasFoil();
        VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)renderType, (boolean)false, (boolean)withGlint);
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        this.rendererPipeline.render(poseStack, model, stack, source, renderType, buffer, 0.0f, partialTick, packedLight);
    }

    private void prepareAnimator(ItemStack stack, AzBakedModel model) {
        this.reusedAzItemAnimator = (AzItemAnimator)this.provider.provideAnimator(this.rendererPipeline.context().currentEntity(), stack);
    }

    @Nullable
    public AzItemAnimator getAnimator() {
        return this.reusedAzItemAnimator;
    }

    public AzItemRendererConfig config() {
        return this.config;
    }
}

