/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.item;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.item.AzItemRendererConfig;
import mod.azure.azurelib.common.render.item.AzItemRendererPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AzItemGuiRenderUtil {
    public static void renderInGui(AzItemRendererConfig config, AzItemRendererPipeline rendererPipeline, ItemStack stack, AzBakedModel model, ItemStack currentItemStack, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        MultiBufferSource.BufferSource bufferSource;
        if (config.useEntityGuiLighting()) {
            Lighting.setupForEntityInInventory();
        } else {
            Lighting.setupForFlatItems();
        }
        AzRendererPipelineContext context = rendererPipeline.context();
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        MultiBufferSource.BufferSource bSource = source instanceof MultiBufferSource.BufferSource ? (bufferSource = (MultiBufferSource.BufferSource)source) : Minecraft.getInstance().levelRenderer.renderBuffers.bufferSource();
        ResourceLocation textureLocation = config.textureLocation(context.currentEntity(), stack);
        RenderType renderType = rendererPipeline.context().getDefaultRenderType(stack, textureLocation, (MultiBufferSource)bSource, partialTick, config.getRenderType(context.currentEntity(), stack), config.alpha(stack));
        boolean withGlint = currentItemStack != null && currentItemStack.hasFoil();
        VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)renderType, (boolean)true, (boolean)withGlint);
        poseStack.pushPose();
        rendererPipeline.render(poseStack, model, stack, (MultiBufferSource)bSource, renderType, buffer, 0.0f, partialTick, packedLight);
        bSource.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        poseStack.popPose();
    }
}

