/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.common.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzProvider;
import mod.azure.azurelib.common.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.common.render.block.AzBlockEntityRendererPipeline;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final AzProvider<Long, T> provider = new AzProvider<Long, BlockEntity>(config::createAnimator, config::modelLocation, blockEntity -> blockEntity.getBlockPos().asLong());
    private final AzBlockEntityRendererPipeline<T> rendererPipeline;
    @Nullable
    private AzBlockAnimator<T> reusedAzBlockAnimator;

    protected AzBlockEntityRenderer(AzBlockEntityRendererConfig<T> config) {
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzBlockEntityRendererPipeline<T> createPipeline(AzBlockEntityRendererConfig<T> config) {
        return new AzBlockEntityRendererPipeline(config, this);
    }

    public void render(@NotNull T entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight, int packedOverlay) {
        AzBlockAnimator cachedEntityAnimator = (AzBlockAnimator)this.provider.provideAnimator(this.rendererPipeline.context().currentEntity(), entity);
        AzBakedModel model = this.provider.provideBakedModel(this.rendererPipeline.context().currentEntity(), entity);
        this.reusedAzBlockAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, model, entity, source, null, null, 0.0f, partialTick, packedLight);
    }

    public AzBlockAnimator<T> getAnimator() {
        return this.reusedAzBlockAnimator;
    }
}

