/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.azure.azurelib.common.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.block.AzBlockEntityRendererPipeline;
import mod.azure.azurelib.common.util.client.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class AzBlockEntityModelRenderer<T extends BlockEntity>
extends AzModelRenderer<Long, T> {
    protected final AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline;

    public AzBlockEntityModelRenderer(AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline, AzLayerRenderer<Long, T> layerRenderer) {
        super(blockEntityRendererPipeline, layerRenderer);
        this.blockEntityRendererPipeline = blockEntityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        BlockEntity entity = (BlockEntity)context.animatable();
        PoseStack poseStack = context.poseStack();
        if (!isReRender) {
            poseStack.translate(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(entity), poseStack);
            AzBlockAnimator<T> animator = this.blockEntityRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, entity, context.partialTick());
            }
        }
        this.blockEntityRendererPipeline.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        ResourceLocation textureLocation = this.blockEntityRendererPipeline.config().textureLocation(context.currentEntity(), entity);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<Long, T> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        BlockEntity entity = (BlockEntity)context.animatable();
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, Vec3.ZERO.toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), new Vector3f((float)entity.getBlockPos().getX(), (float)entity.getBlockPos().getY(), (float)entity.getBlockPos().getZ())));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.renderColor())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.popPose();
    }

    protected Direction getFacing(T block) {
        BlockState blockState = block.getBlockState();
        if (blockState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        }
        if (blockState.hasProperty((Property)DirectionalBlock.FACING)) {
            return (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        }
        return Direction.NORTH;
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case UP: {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            }
        }
    }
}

