/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.value;

import java.lang.reflect.Field;
import java.util.Arrays;
import mod.azure.azurelib.common.config.ConfigUtils;
import mod.azure.azurelib.common.config.Configurable;
import mod.azure.azurelib.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.common.config.format.IConfigFormat;
import mod.azure.azurelib.common.config.value.ArrayValue;
import mod.azure.azurelib.common.config.value.ConfigValue;
import mod.azure.azurelib.common.config.value.DecimalValue;
import mod.azure.azurelib.common.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class DoubleArrayValue
extends ConfigValue<double[]>
implements ArrayValue {
    private boolean fixedSize;
    private DecimalValue.Range range;

    public DoubleArrayValue(ValueData<double[]> valueData) {
        super(valueData);
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    protected void readFieldData(Field field) {
        this.fixedSize = field.getAnnotation(Configurable.FixedSize.class) != null;
        Configurable.DecimalRange decimalRange = field.getAnnotation(Configurable.DecimalRange.class);
        this.range = decimalRange != null ? DecimalValue.Range.newBoundedRange(decimalRange.min(), decimalRange.max()) : DecimalValue.Range.unboundedDouble();
    }

    @Override
    protected double[] getCorrectedValue(double[] in) {
        double[] defaultArray;
        if (this.fixedSize && in.length != (defaultArray = (double[])this.valueData.getDefaultValue()).length) {
            ConfigUtils.logArraySizeCorrectedMessage(this.getId(), Arrays.toString(in), Arrays.toString(defaultArray));
            in = defaultArray;
        }
        if (this.range == null) {
            return in;
        }
        for (int i = 0; i < in.length; ++i) {
            double value = in[i];
            if (this.range.isWithin(value)) continue;
            double corrected = this.range.clamp(value);
            ConfigUtils.logCorrectedMessage(this.getId() + "[" + i + "]", value, corrected);
            in[i] = corrected;
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeDoubleArray(this.getId(), (double[])this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readDoubleArray(this.getId()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        double[] doubles = (double[])this.get();
        for (int i = 0; i < doubles.length; ++i) {
            builder.append(this.elementToString(doubles[i]));
            if (i >= doubles.length - 1) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public DecimalValue.Range getRange() {
        return this.range;
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            double[] arr = (double[])value.get();
            buffer.writeInt(arr.length);
            for (double v : arr) {
                buffer.writeDouble(v);
            }
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            double[] arr = new double[buffer.readInt()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = buffer.readDouble();
            }
            return arr;
        }

        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new DoubleArrayValue(ValueData.of(name, (double[])value, context, comments));
        }
    }
}

