/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.client.screen;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.config.client.DisplayAdapter;
import mod.azure.azurelib.common.config.client.DisplayAdapterManager;
import mod.azure.azurelib.common.config.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.common.config.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.config.value.ConfigValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> valueMap;

    public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        this((Component)Component.translatable((String)("config.screen." + ownerIdentifier)), configId, valueMap, previous);
    }

    public ConfigScreen(Component screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        super(screenTitle, previous, configId);
        this.valueMap = valueMap;
    }

    protected void init() {
        int viewportMin = 35;
        int viewportHeight = this.height - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.addRenderableWidget((GuiEventListener)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.width - 60, 20, value, this.configId));
            widget.setDescriptionRenderer((graphics, widget1, severity, text) -> this.renderEntryDescription(graphics, widget1, severity, text));
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(value, field, widget);
                this.initializeGuiValue(value, widget);
                continue;
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)field.getType().getSimpleName(), (Object)e);
            }
        }
        this.addFooter();
    }

    private void renderEntryDescription(GuiGraphics graphics, AbstractWidget widget, NotificationSeverity severity, List<FormattedCharSequence> text) {
        int x = widget.getX() + 5;
        int y = widget.getY() + widget.getHeight() + 10;
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, graphics, text, x, y);
        } else {
            this.renderNotification(NotificationSeverity.INFO, graphics, text, x, y);
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        int titleWidth = this.font.width((FormattedText)this.title);
        int n = (this.width - titleWidth) / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.title, n, (35 - 9) / 2, 0xFFFFFF, true);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.fill(0, 0, this.width, 35, -1728053248);
        graphics.fill(0, this.height - 30, this.width, this.height, -1728053248);
        graphics.fill(0, 35, this.width, this.height - 30, 0x55000000);
        ConfigScreen.renderScrollbar(graphics, this.width - 5, 35, 5, this.height - 30 - 35, this.index, this.valueMap.size(), this.pageSize);
        this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTicks));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.init(this.minecraft, this.width, this.height);
            return true;
        }
        return false;
    }
}

