/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class AzItemRendererRegistry {
    private static final Map<Item, AzItemRenderer> ITEM_TO_RENDERER = new HashMap<Item, AzItemRenderer>();
    private static final Map<Item, Supplier<AzItemRenderer>> ITEM_TO_RENDERER_SUPPLIER = new HashMap<Item, Supplier<AzItemRenderer>>();

    public static void register(Item item, Supplier<AzItemRenderer> itemRendererSupplier) {
        ITEM_TO_RENDERER_SUPPLIER.put(item, itemRendererSupplier);
        AzIdentityRegistry.register(item, new Item[0]);
    }

    public static void register(Supplier<AzItemRenderer> itemRendererSupplier, Item item, Item ... items) {
        AzItemRendererRegistry.register(item, itemRendererSupplier);
        for (Item otherItem : items) {
            AzItemRendererRegistry.register(otherItem, itemRendererSupplier);
        }
    }

    @Nullable
    public static AzItemRenderer getOrNull(Item item) {
        return ITEM_TO_RENDERER.computeIfAbsent(item, $ -> {
            Supplier<AzItemRenderer> rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(item);
            return rendererSupplier == null ? null : rendererSupplier.get();
        });
    }
}

