/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.core.math.functions.easing.elastic;

import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.math.functions.easing.EasingFunction;

public class EaseOutElastic
extends EasingFunction {
    private static final double C4 = 2.0943951023931953;

    public EaseOutElastic(IValue[] values, String name) throws Exception {
        super(values, name);
    }

    @Override
    protected double ease(double t) {
        if (t == 0.0) {
            return 0.0;
        }
        if (t == 1.0) {
            return 1.0;
        }
        return Math.pow(2.0, -10.0 * t) * Math.sin((t - 0.1) * 2.0943951023931953) + 1.0;
    }
}

