/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.core.math.functions.easing.elastic;

import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.math.functions.easing.EasingFunction;

public class EaseInOutElastic
extends EasingFunction {
    private static final double C5 = 1.3962634015954636;

    public EaseInOutElastic(IValue[] values, String name) throws Exception {
        super(values, name);
    }

    @Override
    protected double ease(double t) {
        if (t == 0.0) {
            return 0.0;
        }
        if (t == 1.0) {
            return 1.0;
        }
        return t < 0.5 ? -(Math.pow(2.0, 20.0 * t - 10.0) * Math.sin((20.0 * t - 11.125) * 1.3962634015954636)) / 2.0 : Math.pow(2.0, -20.0 * t + 10.0) * Math.sin((20.0 * t - 11.125) * 1.3962634015954636) / 2.0 + 1.0;
    }
}

