/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.config.adapter;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeMatcher;
import mod.azure.azurelib.common.internal.common.config.value.BooleanArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.BooleanValue;
import mod.azure.azurelib.common.internal.common.config.value.CharValue;
import mod.azure.azurelib.common.internal.common.config.value.DoubleArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.DoubleValue;
import mod.azure.azurelib.common.internal.common.config.value.EnumArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.EnumValue;
import mod.azure.azurelib.common.internal.common.config.value.FloatArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.FloatValue;
import mod.azure.azurelib.common.internal.common.config.value.IntArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.IntValue;
import mod.azure.azurelib.common.internal.common.config.value.LongArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.LongValue;
import mod.azure.azurelib.common.internal.common.config.value.ObjectValue;
import mod.azure.azurelib.common.internal.common.config.value.StringArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.StringValue;

public final class TypeAdapters {
    private static final Map<TypeMatcher, TypeAdapter> ADAPTER_MAP = new HashMap<TypeMatcher, TypeAdapter>();

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    public static TypeAdapter forType(Class<?> type) {
        return ADAPTER_MAP.entrySet().stream().filter(entry -> ((TypeMatcher)entry.getKey()).test(type)).sorted(Comparator.comparingInt(value -> ((TypeMatcher)value.getKey()).priority())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static void registerTypeAdapter(TypeMatcher matcher, TypeAdapter adapter) {
        if (ADAPTER_MAP.put(matcher, adapter) != null) {
            throw new IllegalArgumentException("Duplicate type matcher with id: " + String.valueOf(matcher.getIdentifier()));
        }
    }

    static {
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchBoolean(), new BooleanValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchCharacter(), new CharValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchInteger(), new IntValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchLong(), new LongValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchFloat(), new FloatValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchDouble(), new DoubleValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchString(), new StringValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchBooleanArray(), new BooleanArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchIntegerArray(), new IntArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchLongArray(), new LongArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchFloatArray(), new FloatArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchDoubleArray(), new DoubleArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchStringArray(), new StringArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchEnum(), new EnumValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchEnumArray(), new EnumArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchObject(), new ObjectValue.Adapter());
    }
}

