/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.client.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.primitive.AzQueuedAnimation;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public record ClientUtils() {
    public static KeyMapping RELOAD;
    public static KeyMapping SCOPE;
    public static KeyMapping FIRE_WEAPON;

    public static void faceRotation(PoseStack poseStack, Entity animatable, float partialTick) {
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot())));
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static AzAnimationController<Object> getCurrentAnimationController(Object target, String controllerName) {
        AzAnimator<Object> animator = AzAnimatorAccessor.getOrNull(target);
        if (animator == null) {
            AzureLib.LOGGER.warn("Could not find animator for target: {}", target);
            return null;
        }
        AzAnimationController<Object> animationController = animator.getAnimationControllerContainer().getOrNull(controllerName);
        if (animationController == null) {
            AzureLib.LOGGER.warn("No animation controller found with name '{}' for target: {}", (Object)controllerName, target);
        }
        return animationController;
    }

    public static double getCurrentAnimationTick(Object target, String controllerName) {
        AzAnimationController<Object> animationController;
        if (target instanceof Entity) {
            Entity entity = (Entity)target;
            if (!entity.level().isClientSide) {
                AzureLib.LOGGER.warn("Animation tick can only be retrieved on the client side for target: {}", target);
                return 0.0;
            }
        }
        if ((animationController = ClientUtils.getCurrentAnimationController(target, controllerName)) == null) {
            AzureLib.LOGGER.warn("No animation controller available for target: {} controller: {}", target, (Object)controllerName);
            return 0.0;
        }
        return animationController.controllerTimer().getAdjustedTick();
    }

    public static double getCurrentAnimationLength(Object target, String controllerName) {
        AzAnimationController<Object> animationController = ClientUtils.getCurrentAnimationController(target, controllerName);
        if (animationController == null) {
            AzureLib.LOGGER.warn("No animation controller found for target: {} controller: {}", target, (Object)controllerName);
            return 0.0;
        }
        AzQueuedAnimation currentAnimation = animationController.currentAnimation();
        if (currentAnimation == null) {
            AzureLib.LOGGER.warn("No current animation found for target: {} controller: {}", target, (Object)controllerName);
            return 0.0;
        }
        return currentAnimation.animation().length();
    }
}

