/*
 * Decompiled with CFR 0.152.
 */
package net.cerealcamera.aviator_dream.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.TrailDescriptor;
import net.cerealcamera.aviator_dream.AviatorDreams;
import net.cerealcamera.aviator_dream.Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class DouglasC47Entity
extends AirplaneEntity {
    private float reactionSpeed = 150.0f;
    public byte durationHigh = 0;
    public byte durationLow = 0;

    public DouglasC47Entity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    protected float getEngineReactionSpeed() {
        return this.reactionSpeed;
    }

    protected SoundEvent getEngineSound() {
        return SoundEvents.EMPTY;
    }

    protected SoundEvent getEngineStartSound() {
        return Sounds.R1830_START.get();
    }

    public Item asItem() {
        return AviatorDreams.DOUGLAS_C47_ITEM.get();
    }

    public float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return (float)(Math.sqrt(this.getDeltaMovement().length()) * (double)(0.5f - this.pressingInterpolatedX.getSmooth() * trail.x() * 0.025f) - 0.25);
    }

    public void tick() {
        super.tick();
        this.reactionSpeed = this.getEngineTarget() <= this.getEnginePower() ? 200.0f : 150.0f;
        if (this.level().isClientSide) {
            if (this.durationLow > 0) {
                this.durationLow = (byte)(this.durationLow - 1);
            } else if (this.durationLow == 0 && (double)this.getEngineTarget() <= 0.25 && this.getEngineTarget() != 0.0f && this.getFuelUtilization() != 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), Sounds.R1830_IDLE.get(), this.getSoundSource(), 1.0f, 1.0f, false);
                this.durationLow = (byte)50;
            }
            if (this.durationHigh > 0) {
                this.durationHigh = (byte)(this.durationHigh - 1);
            } else if (this.durationHigh == 0 && (double)this.getEngineTarget() > 0.25 && this.getEngineTarget() != 0.0f && this.getFuelUtilization() != 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), Sounds.R1820_PROP.get(), this.getSoundSource(), 1.0f, 1.0f, false);
                this.durationHigh = (byte)69;
            }
        }
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.1f);
    }

    public double getZoom() {
        return 35.0;
    }

    public int getDefaultDyeColor() {
        return 15672099;
    }
}

