/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class SimpleMapContentRegistry<V extends Identifiable> {
    private final Map<ResourceLocation, V> entries = new Object2ObjectOpenHashMap();
    private final List<ResourceLocation> orderedKeys = new ArrayList<ResourceLocation>();

    public V register(V entry) {
        this.entries.put(entry.getId(), entry);
        this.orderedKeys.add(entry.getId());
        return entry;
    }

    public V get(ResourceLocation name) {
        return (V)((Identifiable)this.entries.get(name));
    }

    public Optional<V> getOptional(ResourceLocation name) {
        return Optional.ofNullable((Identifiable)this.entries.get(name));
    }

    public V getOrDefault(ResourceLocation name) {
        if (this.orderedKeys.size() <= 0) {
            throw new IllegalStateException("Tried to get from empty registry!");
        }
        return (V)this.entries.getOrDefault(name, (Identifiable)this.entries.get(this.orderedKeys.get(0)));
    }

    public void forEach(Consumer<V> action) {
        this.orderedKeys.forEach((? super T k) -> action.accept((Identifiable)this.entries.get(k)));
    }

    public Codec<V> codec() {
        return ResourceLocation.CODEC.xmap(this::get, Identifiable::getId);
    }

    public static interface Identifiable {
        public ResourceLocation getId();
    }

    public static class Serializing<V extends Identifiable>
    extends SimpleMapContentRegistry<V>
    implements Codec<V> {
        public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.CODEC.decode(ops, input).flatMap(pair -> this.getOptional((ResourceLocation)pair.getFirst()).map(v -> DataResult.success((Object)pair.mapFirst(id -> v))).orElseGet(() -> DataResult.error(() -> String.format("Entry '%s' does not exist", pair.getFirst()))));
        }

        public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(input.getId().toString()));
        }
    }
}

