/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.sound;

import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.sound.AdvancedSoundInstance;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.lwjgl.openal.AL10;

public abstract class AutomobileSoundInstance
extends AbstractTickableSoundInstance
implements AdvancedSoundInstance {
    protected final Minecraft client;
    protected final AutomobileEntity automobile;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public AutomobileSoundInstance(SoundEvent sound, Minecraft client, AutomobileEntity automobile) {
        super(sound, SoundSource.AMBIENT, automobile.getCommandSenderWorld().getRandom());
        this.client = client;
        this.automobile = automobile;
        this.looping = true;
        this.delay = 0;
        this.lastDistance = this.getPosition(automobile).subtract(client.player.position()).length();
    }

    protected abstract boolean canPlay(AutomobileEntity var1);

    protected abstract float getPitch(AutomobileEntity var1);

    protected abstract float getVolume(AutomobileEntity var1);

    protected double dopplerScale() {
        return 0.16;
    }

    protected float audibleDistance() {
        return 18.0f;
    }

    protected Vec3 getPosition(AutomobileEntity auto) {
        return auto.position();
    }

    public void tick() {
        LocalPlayer player = this.client.player;
        if (this.automobile.isRemoved() || player == null) {
            this.stop();
            return;
        }
        if (!this.canPlay(this.automobile)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.stop();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.volume = this.getVolume(this.automobile) * (float)this.fade / 3.0f;
        Vec3 pos = this.getPosition(this.automobile);
        this.x = pos.x();
        this.y = pos.y();
        this.z = pos.z();
        this.pitch = this.getPitch(this.automobile);
        if (player.getVehicle() != this.automobile) {
            double distance = pos.subtract(player.position()).length();
            double dDist = Math.clamp(this.lastDistance - distance, -1.5, 1.5);
            this.pitch += (float)(this.dopplerScale() * dDist);
            this.lastDistance -= dDist;
        } else {
            this.lastDistance = 0.0;
        }
    }

    @Override
    public IntConsumer setupALState() {
        float dist = this.audibleDistance();
        return source -> AL10.alSourcef((int)source, (int)4131, (float)dist);
    }

    public static class SkiddingSound
    extends AutomobileSoundInstance {
        public SkiddingSound(Minecraft client, AutomobileEntity automobile) {
            super(AutomobilitySounds.SKID.require(), client, automobile);
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return automobile.isDrifting() || automobile.burningOut();
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return automobile.burningOut() ? 0.75f : 1.0f + 0.056f * ((float)Math.min(automobile.getTurboCharge(), 115) / 115.0f);
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return automobile.automobileOnGround() ? 1.0f : 0.0f;
        }

        @Override
        protected Vec3 getPosition(AutomobileEntity auto) {
            return auto.getTailPos();
        }
    }

    public static class EngineSound
    extends AutomobileSoundInstance {
        public EngineSound(Minecraft client, AutomobileEntity automobile) {
            super(automobile.getEngine().sound().get(), client, automobile);
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return automobile.engineRunning();
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return (float)(Math.pow(4.0, (double)automobile.getEffectiveSpeed() - 0.9) + 0.32);
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return 1.0f;
        }

        @Override
        protected Vec3 getPosition(AutomobileEntity auto) {
            Vec3 ePos = auto.getFrame().model().enginePos().scale(0.0625);
            Vector3d ePosD = new Vector3d(ePos.x(), ePos.y(), ePos.z());
            auto.localPosToWorldSpace(ePosD);
            return new Vec3(ePosD.x(), ePosD.y(), ePosD.z());
        }
    }
}

