/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import io.github.foundationgames.automobility.automobile.attachment.rear.BlockRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AutomobileContainerLevelAccess
implements ContainerLevelAccess {
    private final Level world;
    private final AutomobileEntity automobile;

    public AutomobileContainerLevelAccess(AutomobileEntity automobile) {
        this.world = automobile.level();
        this.automobile = automobile;
    }

    public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> getter) {
        return Optional.of(getter.apply(this.world, this.automobile.blockPosition()));
    }

    public BlockState getAttachmentBlockState() {
        BlockState blockState;
        RearAttachment rearAttachment = this.automobile.getRearAttachment();
        if (rearAttachment instanceof BlockRearAttachment) {
            BlockRearAttachment att = (BlockRearAttachment)rearAttachment;
            blockState = att.block;
        } else {
            blockState = Blocks.AIR.defaultBlockState();
        }
        return blockState;
    }
}

