/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import io.github.foundationgames.automobility.screen.AutoMechanicTableScreenHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AutoMechanicTableScreen
extends AbstractContainerScreen<AutoMechanicTableScreenHandler> {
    private static final ResourceLocation TEXTURE = Automobility.rl("textures/gui/container/auto_mechanic_table.png");
    private static final int RECIPE_BUTTON_SIZE = 17;
    private static final int RECIPE_PANEL_WIDTH = 85;
    private static final int RECIPE_PANEL_HEIGHT = 51;
    private static final int CATEGORY_BUTTON_WIDTH = 12;
    private static final int CATEGORY_BUTTON_HEIGHT = 15;
    private static final int CATEGORY_BUTTON_AREA_WIDTH = 91;
    private static final int SCROLL_BAR_WIDTH = 3;
    private static final int SCROLL_BAR_HEIGHT = 10;
    private static final int SCROLL_BAR_AREA_HEIGHT = 51;
    private long time = 0L;
    private int recipePanelX;
    private int recipePanelY;
    private int categoryButtonsX;
    private int categoryButtonsY;
    private int currentCategory = 0;
    private int recipeScroll = 0;
    private final List<ResourceLocation> orderedCategories = AutoMechanicTableScreen.createDefaultCategories();
    private final Map<ResourceLocation, List<RecipeEntry>> recipes = new HashMap<ResourceLocation, List<RecipeEntry>>();
    private FormattedCharSequence categoryTitle;
    private ItemStack hoveredMissingIngredient = null;

    public AutoMechanicTableScreen(AutoMechanicTableScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 209;
        this.titleLabelY = 8;
        for (int id = 0; id < handler.recipes.size(); ++id) {
            AutoMechanicTableRecipe recipe = handler.recipes.get(id);
            ResourceLocation category = recipe.getCategory();
            this.recipes.computeIfAbsent(category, cat -> new ArrayList());
            if (!this.orderedCategories.contains(category)) {
                this.orderedCategories.add(category);
            }
            this.recipes.get(category).add(new RecipeEntry(id, recipe));
        }
        this.inventoryLabelY = this.topPos + 115;
    }

    private static List<ResourceLocation> createDefaultCategories() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(Automobility.rl("frames"));
        list.add(Automobility.rl("engines"));
        list.add(Automobility.rl("wheels"));
        return list;
    }

    protected void init() {
        super.init();
        this.recipePanelX = this.leftPos + 76;
        this.recipePanelY = this.topPos + 21;
        this.categoryButtonsX = this.leftPos + 75;
        this.categoryButtonsY = this.topPos + 4;
        this.categoryTitle = this.createCategoryTitle(this.orderedCategories.get(0));
    }

    protected void containerTick() {
        super.containerTick();
        ++this.time;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    private void preDraw() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        this.preDraw();
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.drawCategoryBar(graphics, mouseX, mouseY);
        this.drawRecipes(graphics, mouseX, mouseY);
        this.drawMissingIngredients(graphics);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        int hoveredRecipe = this.getHoveredRecipe(mouseX, mouseY);
        if (hoveredRecipe >= 0) {
            graphics.renderTooltip(this.font, ((AutoMechanicTableScreenHandler)this.menu).recipes.get(hoveredRecipe).getResultItem(), mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mx, int my) {
        super.renderTooltip(graphics, mx, my);
        if (this.hoveredMissingIngredient != null) {
            List tt = AutoMechanicTableScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.hoveredMissingIngredient);
            if (!tt.isEmpty()) {
                tt.set(0, ((Component)tt.getFirst()).copy().withStyle(ChatFormatting.RED));
            }
            graphics.renderTooltip(this.minecraft.font, tt, this.hoveredMissingIngredient.getTooltipImage(), mx, my);
        }
    }

    private void changeCategory(int by) {
        this.currentCategory = Math.floorMod(this.currentCategory + by, this.orderedCategories.size());
        this.categoryTitle = this.createCategoryTitle(this.orderedCategories.get(this.currentCategory));
        this.recipeScroll = 0;
    }

    private FormattedCharSequence createCategoryTitle(ResourceLocation category) {
        String translated = I18n.get((String)("part_category." + category.getNamespace() + "." + category.getPath()), (Object[])new Object[0]);
        if (this.font.width(translated) > 64) {
            return Component.literal((String)(this.font.plainSubstrByWidth(translated, 57) + "...")).getVisualOrderText();
        }
        return Component.literal((String)this.font.plainSubstrByWidth(translated, 64)).getVisualOrderText();
    }

    private void buttonClicked() {
        if (this.minecraft != null) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int selectedCatButton = this.getHoveredCategoryButton((int)mouseX, (int)mouseY);
            if (selectedCatButton != 0) {
                this.changeCategory(selectedCatButton);
                this.buttonClicked();
                return true;
            }
            int recipe = this.getHoveredRecipe((int)mouseX, (int)mouseY);
            if (recipe >= 0) {
                this.selectRecipe(recipe);
                this.buttonClicked();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void selectRecipe(int id) {
        ((AutoMechanicTableScreenHandler)this.menu).clickMenuButton((Player)this.minecraft.player, id);
        this.minecraft.gameMode.handleInventoryButtonClick(((AutoMechanicTableScreenHandler)this.menu).containerId, id);
    }

    private int getMaxRecipeScroll() {
        return Math.max(0, Mth.ceil((float)((float)this.getRecipeList().size() / 5.0f)) - 3);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0 && this.getHoveredRecipe((int)mouseX, (int)mouseY) >= -1) {
            this.recipeScroll += scrollY > 0.0 ? -1 : 1;
            this.recipeScroll = Mth.clamp((int)this.recipeScroll, (int)0, (int)this.getMaxRecipeScroll());
            return true;
        }
        return false;
    }

    protected final void drawMissingIngredient(GuiGraphics graphics, Ingredient ing, int x, int y, boolean hovered) {
        graphics.fill(x, y, x + 16, y + 16, 1174339584);
        ItemStack[] stacks = ing.getItems();
        ItemStack stack = stacks[Mth.floor((float)((float)this.time / 30.0f)) % stacks.length];
        graphics.renderFakeItem(stack, x, y);
        RenderSystem.depthMask((boolean)false);
        graphics.fill(x, y, x + 16, y + 16, 0x30FFFFFF);
        RenderSystem.depthMask((boolean)true);
        if (hovered) {
            this.hoveredMissingIngredient = stack;
        }
    }

    protected void drawMissingIngredients(GuiGraphics graphics) {
        SimpleContainer inputInv = ((AutoMechanicTableScreenHandler)this.menu).inputInv;
        ArrayDeque<Ingredient> missingIngs = new ArrayDeque<Ingredient>(((AutoMechanicTableScreenHandler)this.menu).missingIngredients);
        this.hoveredMissingIngredient = null;
        for (int i = 0; i < inputInv.getContainerSize(); ++i) {
            if (missingIngs.isEmpty()) continue;
            int x = this.leftPos + 8 + i * 18;
            int y = this.topPos + 88;
            if (!inputInv.getItem(i).isEmpty()) continue;
            Ingredient ing = missingIngs.removeFirst();
            this.drawMissingIngredient(graphics, ing, x, y, this.hoveredSlot != null && this.hoveredSlot.index == i);
        }
    }

    protected List<RecipeEntry> getRecipeList() {
        if (this.currentCategory < this.orderedCategories.size() && this.currentCategory >= 0) {
            return Objects.requireNonNullElseGet(this.recipes.get(this.orderedCategories.get(this.currentCategory)), Collections::emptyList);
        }
        return Collections.emptyList();
    }

    protected int getHoveredCategoryButton(int mouseX, int mouseY) {
        if (mouseY > this.categoryButtonsY && mouseY < this.categoryButtonsY + 15) {
            int relX = mouseX - this.categoryButtonsX;
            if (relX < 0 || relX > 91) {
                return 0;
            }
            if (relX < 12) {
                return -1;
            }
            if (relX > 79) {
                return 1;
            }
        }
        return 0;
    }

    protected int getHoveredRecipe(int mouseX, int mouseY) {
        if (this.currentCategory < this.orderedCategories.size() && this.currentCategory >= 0 && (mouseX -= this.recipePanelX) >= 0 && mouseX < 85 && (mouseY -= this.recipePanelY) >= 0 && mouseY < 51) {
            int row = Mth.floor((float)((float)mouseY / 17.0f));
            int col = Mth.floor((float)((float)mouseX / 17.0f));
            if (row >= 0 && col >= 0) {
                int idx = 5 * (row + this.recipeScroll) + col;
                List<RecipeEntry> recipes = this.recipes.get(this.orderedCategories.get(this.currentCategory));
                if (idx < recipes.size()) {
                    return recipes.get(idx).id();
                }
                return -1;
            }
        }
        return -2;
    }

    protected void drawCategoryBar(GuiGraphics graphics, int mouseX, int mouseY) {
        int hoveredCatButton = this.getHoveredCategoryButton(mouseX, mouseY);
        this.preDraw();
        graphics.blit(TEXTURE, this.categoryButtonsX, this.categoryButtonsY, 176, 17 + (hoveredCatButton < 0 ? 15 : 0), 12, 15);
        graphics.blit(TEXTURE, this.categoryButtonsX + 79, this.categoryButtonsY, 188, 17 + (hoveredCatButton > 0 ? 15 : 0), 12, 15);
        if (this.categoryTitle != null) {
            graphics.drawCenteredString(this.font, this.categoryTitle, this.leftPos + 120, this.topPos + 8, 0xFFFFFF);
        }
    }

    protected void drawRecipes(GuiGraphics graphics, int mouseX, int mouseY) {
        List<RecipeEntry> recipes;
        if (this.orderedCategories.size() > 0 && (recipes = this.recipes.get(this.orderedCategories.get(this.currentCategory))) != null) {
            for (int row = 0; row < 3; ++row) {
                int idx;
                for (int col = 0; col < 5 && (idx = 5 * this.recipeScroll + 5 * row + col) < recipes.size(); ++col) {
                    int x = col * 17 + this.recipePanelX;
                    int y = row * 17 + this.recipePanelY;
                    RecipeEntry entry = recipes.get(idx);
                    RecipeButtonState state = RecipeButtonState.DEFAULT;
                    if (((AutoMechanicTableScreenHandler)this.menu).getSelectedRecipe().isPresent() && ((AutoMechanicTableScreenHandler)this.menu).getSelectedRecipeId() == entry.id()) {
                        state = RecipeButtonState.SELECTED;
                    } else if (this.getHoveredRecipe(mouseX, mouseY) == entry.id()) {
                        state = RecipeButtonState.HOVERED;
                    }
                    this.drawRecipeEntry(entry, graphics, x, y, state);
                }
            }
        }
        this.preDraw();
        int maxScroll = this.getMaxRecipeScroll();
        int scrollBarX = this.leftPos + 162;
        int scrollBarY = this.topPos + 21;
        if (maxScroll > 0) {
            scrollBarY += (int)(41.0f * ((float)this.recipeScroll / (float)maxScroll));
        }
        graphics.blit(TEXTURE, scrollBarX, scrollBarY, 227, 0, 3, 10);
    }

    protected void drawRecipeEntry(RecipeEntry entry, GuiGraphics graphics, int x, int y, RecipeButtonState state) {
        this.preDraw();
        graphics.blit(TEXTURE, x, y, 176 + state.ordinal() * 17, 0, 17, 17);
        ItemStack stack = entry.recipe.getResultItem();
        graphics.renderFakeItem(stack, x, y);
    }

    public record RecipeEntry(int id, AutoMechanicTableRecipe recipe) {
    }

    public static enum RecipeButtonState {
        DEFAULT,
        HOVERED,
        SELECTED;

    }
}

