/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.item.CustomCreativeOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.Vec3;

public class AutomobileItem
extends Item
implements CustomCreativeOutput {
    public static final List<AutomobileData> PREFABS = new ArrayList<AutomobileData>();

    public AutomobileItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide()) {
            ItemStack stack = context.getItemInHand();
            AutomobileData data = (AutomobileData)stack.get(AutomobilityItems.COMPONENT_AUTOMOBILE_DATA.require());
            AutomobileEntity e = new AutomobileEntity(AutomobilityEntities.AUTOMOBILE.require(), context.getLevel());
            Vec3 pos = context.getClickLocation();
            e.moveTo(pos.x, pos.y, pos.z, context.getHorizontalDirection().toYRot(), 0.0f);
            Holder frame = context.getLevel().registryAccess().registryOrThrow(AutomobileFrame.REGISTRY).getHolder(data.frame()).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileFrame.EMPTY));
            Holder wheel = context.getLevel().registryAccess().registryOrThrow(AutomobileWheel.REGISTRY).getHolder(data.wheel()).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileWheel.EMPTY));
            Holder engine = context.getLevel().registryAccess().registryOrThrow(AutomobileEngine.REGISTRY).getHolder(data.engine()).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileEngine.EMPTY));
            e.setComponents((Holder<AutomobileFrame>)frame, (Holder<AutomobileWheel>)wheel, (Holder<AutomobileEngine>)engine);
            context.getLevel().addFreshEntity((Entity)e);
            stack.shrink(1);
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static void addPrefabs(AutomobileData ... prefabs) {
        PREFABS.addAll(Arrays.asList(prefabs));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        AutomobileData data = (AutomobileData)stack.get(AutomobilityItems.COMPONENT_AUTOMOBILE_DATA.require());
        if (data != null) {
            data.addToTooltip(context, tooltipComponents::add, tooltipFlag);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public void provideCreativeOutput(CreativeModeTab.Output output, HolderLookup.Provider registries) {
        for (AutomobileData prefab : PREFABS) {
            output.accept(prefab.asStack());
        }
    }
}

